/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.scan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;

public final class TemplateScanner {
    public static StructureTemplate scan(World world, BlockPosition min, BlockPosition max, BlockPosition key, int turns, String name) {
        int xSize = max.x - min.x + 1;
        int ySize = max.y - min.y + 1;
        int zSize = max.z - min.z + 1;
        int xOutSize = xSize;
        int zOutSize = zSize;
        for (int i = 0; i < turns; ++i) {
            int swap = xOutSize;
            xOutSize = zOutSize;
            zOutSize = swap;
        }
        key = BlockTools.rotateInArea(key.sub(min), xSize, zSize, turns);
        short[] templateRuleData = new short[xSize * ySize * zSize];
        HashMap pluginBlockRuleMap = new HashMap();
        ArrayList<Object> currentRulesAll = new ArrayList<Object>();
        Object scannedBlockRule = null;
        BlockPosition destination = new BlockPosition();
        int nextRuleID = 1;
        for (int scanY = min.y; scanY <= max.y; ++scanY) {
            for (int scanZ = min.z; scanZ <= max.z; ++scanZ) {
                for (int scanX = min.x; scanX <= max.x; ++scanX) {
                    String pluginId;
                    destination = BlockTools.rotateInArea(new BlockPosition(scanX, scanY, scanZ).sub(min), xSize, zSize, turns);
                    Block scannedBlock = world.func_147439_a(scanX, scanY, scanZ);
                    if (scannedBlock == null || AWStructureStatics.shouldSkipScan(scannedBlock) || scannedBlock.isAir((IBlockAccess)world, scanX, scanY, scanZ) || (pluginId = StructurePluginManager.INSTANCE.getPluginNameFor(scannedBlock)) == null) continue;
                    int meta = world.func_72805_g(scanX, scanY, scanZ);
                    ArrayList<Object> pluginBlockRules = (ArrayList<Object>)pluginBlockRuleMap.get(pluginId);
                    if (pluginBlockRules == null) {
                        pluginBlockRules = new ArrayList<Object>();
                        pluginBlockRuleMap.put(pluginId, pluginBlockRules);
                    }
                    boolean found = false;
                    for (Object rule : pluginBlockRules) {
                        if (!((TemplateRuleBlock)rule).shouldReuseRule(world, scannedBlock, meta, turns, scanX, scanY, scanZ)) continue;
                        scannedBlockRule = rule;
                        found = true;
                        break;
                    }
                    if (!found && (scannedBlockRule = StructurePluginManager.INSTANCE.getRuleForBlock(world, scannedBlock, turns, scanX, scanY, scanZ)) != null) {
                        ((TemplateRuleBlock)scannedBlockRule).ruleNumber = nextRuleID++;
                        pluginBlockRules.add(scannedBlockRule);
                        currentRulesAll.add(scannedBlockRule);
                    }
                    int index = StructureTemplate.getIndex(destination.x, destination.y, destination.z, xOutSize, ySize, zOutSize);
                    templateRuleData[index] = (short)((TemplateRuleBlock)scannedBlockRule).ruleNumber;
                }
            }
        }
        ArrayList<TemplateRuleEntity> scannedEntityRules = new ArrayList<TemplateRuleEntity>();
        List entitiesInAABB = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1)));
        nextRuleID = 0;
        for (Entity e : entitiesInAABB) {
            int ez;
            int ey;
            int ex;
            TemplateRuleEntity scannedEntityRule = StructurePluginManager.INSTANCE.getRuleForEntity(world, e, turns, ex = MathHelper.func_76128_c((double)e.field_70165_t), ey = MathHelper.func_76128_c((double)e.field_70163_u), ez = MathHelper.func_76128_c((double)e.field_70161_v));
            if (scannedEntityRule == null) continue;
            destination = BlockTools.rotateInArea(new BlockPosition(ex, ey, ez).sub(min), xSize, zSize, turns);
            scannedEntityRule.ruleNumber = nextRuleID++;
            scannedEntityRule.setPosition(destination);
            scannedEntityRules.add(scannedEntityRule);
        }
        TemplateRule[] templateRules = new TemplateRule[currentRulesAll.size() + 1];
        for (int i = 0; i < currentRulesAll.size(); ++i) {
            templateRules[i + 1] = (TemplateRule)currentRulesAll.get(i);
        }
        TemplateRuleEntity[] entityRules = new TemplateRuleEntity[scannedEntityRules.size()];
        for (int i = 0; i < scannedEntityRules.size(); ++i) {
            entityRules[i] = (TemplateRuleEntity)scannedEntityRules.get(i);
        }
        StructureTemplate template = new StructureTemplate(name, xOutSize, ySize, zOutSize, key.x, key.y, key.z);
        template.setTemplateData(templateRuleData);
        template.setRuleArray(templateRules);
        template.setEntityRules(entityRules);
        return template;
    }
}

