/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class StructureValidatorUnderground
extends StructureValidator {
    int minGenerationDepth;
    int maxGenerationDepth;
    int minOverfill;

    public StructureValidatorUnderground() {
        super(StructureValidationType.UNDERGROUND);
    }

    @Override
    protected void readFromLines(List<String> lines) {
        for (String line : lines) {
            if (StructureValidatorUnderground.startLow(line, "mingenerationdepth=")) {
                this.minGenerationDepth = StringTools.safeParseInt("=", line);
                continue;
            }
            if (StructureValidatorUnderground.startLow(line, "maxgenerationdepth=")) {
                this.maxGenerationDepth = StringTools.safeParseInt("=", line);
                continue;
            }
            if (!StructureValidatorUnderground.startLow(line, "minoverfill=")) continue;
            this.minOverfill = StringTools.safeParseInt("=", line);
        }
    }

    @Override
    protected void write(BufferedWriter out) throws IOException {
        out.write("minGenerationDepth=" + this.minGenerationDepth);
        out.newLine();
        out.write("maxGenerationDepth=" + this.maxGenerationDepth);
        out.newLine();
        out.write("minOverfill=" + this.minOverfill);
        out.newLine();
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        int tHeight;
        int low;
        y = WorldStructureGenerator.getTargetY(world, x, z, true);
        return y > (low = this.minGenerationDepth + (tHeight = template.ySize - template.yOffset) + this.minOverfill);
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        y = WorldStructureGenerator.getTargetY(world, x, z, true);
        int range = this.maxGenerationDepth - this.minGenerationDepth + 1;
        int tHeight = template.ySize - template.yOffset;
        return y - this.minOverfill - world.field_73012_v.nextInt(range) - tHeight;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int minY = bb.min.y + template.yOffset + this.minOverfill;
        for (int bx = bb.min.x; bx <= bb.max.x; ++bx) {
            for (int bz = bb.min.z; bz <= bb.max.z; ++bz) {
                int topBlockY = WorldStructureGenerator.getTargetY(world, bx, bz, true);
                if (topBlockY > minY) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
    }
}

