/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class StructureValidatorHarbor
extends StructureValidator {
    BlockPosition testMin = new BlockPosition();
    BlockPosition testMax = new BlockPosition();
    Set<String> validTargetBlocks = new HashSet<String>();
    Set<String> validTargetBlocksSide = new HashSet<String>();
    Set<String> validTargetBlocksRear = new HashSet<String>();

    public StructureValidatorHarbor() {
        super(StructureValidationType.HARBOR);
        this.validTargetBlocks.addAll(WorldStructureGenerator.defaultTargetBlocks);
        this.validTargetBlocksSide.addAll(WorldStructureGenerator.defaultTargetBlocks);
        this.validTargetBlocksRear.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150355_j));
        this.validTargetBlocksRear.add(BlockDataManager.INSTANCE.getNameForBlock((Block)Blocks.field_150358_i));
        this.validTargetBlocksSide.add(BlockDataManager.INSTANCE.getNameForBlock(Blocks.field_150355_j));
        this.validTargetBlocksSide.add(BlockDataManager.INSTANCE.getNameForBlock((Block)Blocks.field_150358_i));
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, int face, StructureTemplate template) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block != null && this.validTargetBlocks.contains(BlockDataManager.INSTANCE.getNameForBlock(block))) {
            this.testMin = new BlockPosition(x, y, z).moveForward(face, template.zOffset);
            int by = WorldStructureGenerator.getTargetY(world, this.testMin.x, this.testMin.z, false);
            if (y - by > this.getMaxFill()) {
                return false;
            }
            block = world.func_147439_a(this.testMin.x, by, this.testMin.z);
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        this.testMin = new BlockPosition(x, y, z).moveForward(face, template.zOffset);
        return WorldStructureGenerator.getTargetY(world, this.testMin.x, this.testMin.z, false) + 1;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        int bz;
        int bx;
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        StructureBB temp = bb.getFrontCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.x; bx <= this.testMax.x; ++bx) {
            for (bz = this.testMin.z; bz <= this.testMax.z; ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, this.validTargetBlocks)) continue;
                return false;
            }
        }
        temp = bb.getRearCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.x; bx <= this.testMax.x; ++bx) {
            for (bz = this.testMin.z; bz <= this.testMax.z; ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, this.validTargetBlocksRear)) continue;
                return false;
            }
        }
        temp = bb.getRightCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.x; bx <= this.testMax.x; ++bx) {
            for (bz = this.testMin.z; bz <= this.testMax.z; ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, this.validTargetBlocksSide)) continue;
                return false;
            }
        }
        temp = bb.getLeftCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.x; bx <= this.testMax.x; ++bx) {
            for (bz = this.testMin.z; bz <= this.testMax.z; ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, this.validTargetBlocksSide)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void preGeneration(World world, BlockPosition pos, int face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
    }

    @Override
    public void handleClearAction(World world, int x, int y, int z, StructureTemplate template, StructureBB bb) {
        if (y >= bb.min.y + template.yOffset) {
            super.handleClearAction(world, x, y, z, template, bb);
        } else {
            world.func_147449_b(x, y, z, Blocks.field_150355_j);
        }
    }
}

