/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.gate;

import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateBasic;
import org.lwjgl.opengl.GL11;

public final class RenderGateSingle
extends RenderGateBasic {
    @Override
    protected BlockPosition getMin(EntityGate gate) {
        return BlockTools.getMin(gate.pos1, gate.pos2);
    }

    @Override
    protected BlockPosition getMax(EntityGate gate) {
        return BlockTools.getMax(gate.pos1, gate.pos2);
    }

    @Override
    protected void postRender(EntityGate gate, int x, float width, int y, float height, boolean wideOnXAxis, float axisRotation, float frame) {
        boolean opensReverse = gate.pos1.x > gate.pos2.x || gate.pos1.z > gate.pos2.z;
        float wallTx = wideOnXAxis ? gate.edgePosition + gate.openingSpeed * (1.0f - frame) : 0.0f;
        float wallTz = wideOnXAxis ? 0.0f : gate.edgePosition + gate.openingSpeed * (1.0f - frame);
        boolean render = false;
        if (opensReverse) {
            if (wideOnXAxis && (float)x - wallTx > -0.5f || !wideOnXAxis && (float)x - wallTz > -0.5f) {
                render = true;
            }
        } else if (wideOnXAxis && wallTx + (float)x < gate.edgeMax - 0.5f || !wideOnXAxis && wallTz + (float)x < gate.edgeMax - 0.5f) {
            render = true;
        }
        if (render) {
            if (opensReverse) {
                wallTx *= -1.0f;
                wallTz *= -1.0f;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)wallTx, (float)0.0f, (float)wallTz);
            this.model.setModelRotation(axisRotation);
            if (gate.getGateType().getModelType() == 0) {
                this.model.renderSolidWall();
            } else {
                this.model.renderBars();
            }
            GL11.glPopMatrix();
        }
    }
}

