/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.gate;

import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateBasic;
import org.lwjgl.opengl.GL11;

public final class RenderGateDouble
extends RenderGateBasic {
    @Override
    protected BlockPosition getMin(EntityGate gate) {
        return BlockTools.getMin(gate.pos1, gate.pos2);
    }

    @Override
    protected BlockPosition getMax(EntityGate gate) {
        return BlockTools.getMax(gate.pos1, gate.pos2);
    }

    @Override
    protected void postRender(EntityGate gate, int x, float width, int y, float height, boolean wideOnXAxis, float axisRotation, float frame) {
        float wallTz;
        float move;
        boolean render = false;
        if ((float)x < width * 0.5f) {
            move = -gate.edgePosition - gate.openingSpeed * (1.0f - frame);
            if ((float)x + move > -0.5f) {
                render = true;
            }
        } else {
            move = gate.edgePosition + gate.openingSpeed * (1.0f - frame);
            if ((float)x + move <= width - 0.475f) {
                render = true;
            }
        }
        float wallTx = wideOnXAxis ? move : 0.0f;
        float f = wallTz = wideOnXAxis ? 0.0f : move;
        if (render) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)wallTx, (float)0.0f, (float)wallTz);
            this.model.setModelRotation(axisRotation);
            if (gate.getGateType().getModelType() == 0) {
                this.model.renderSolidWall();
            } else {
                this.model.renderBars();
            }
            GL11.glPopMatrix();
        }
    }
}

