/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.io.File;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateLoader;
import net.shadowmage.ancientwarfare.structure.template.save.TemplateExporter;
import net.shadowmage.ancientwarfare.structure.template.scan.TemplateScanner;

public class ItemStructureScanner
extends Item
implements IItemKeyInterface,
IBoxRenderer {
    public ItemStructureScanner(String localizationKey) {
        this.func_77655_b(localizationKey);
        this.func_77637_a(AWStructuresItemLoader.structureTab);
        this.func_77625_d(1);
        this.func_111206_d("ancientwarfare:structure/" + localizationKey);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (par1ItemStack != null) {
            ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(par1ItemStack);
            String key = InputHandler.instance.getKeybindBinding("keybind.alt_item_use_1");
            if (!viewSettings.hasPos1()) {
                list.add(StatCollector.func_74837_a((String)"guistrings.structure.scanner.select_first_pos", (Object[])new Object[]{key}));
                list.add("(1/4)");
            } else if (!viewSettings.hasPos2()) {
                list.add(StatCollector.func_74837_a((String)"guistrings.structure.scanner.select_second_pos", (Object[])new Object[]{key}));
                list.add("(2/4)");
            } else if (!viewSettings.hasBuildKey()) {
                list.add(StatCollector.func_74837_a((String)"guistrings.structure.scanner.select_offset", (Object[])new Object[]{key}));
                list.add("(3/4)");
            } else {
                list.add(key + " : " + StatCollector.func_74838_a((String)"guistrings.structure.scanner.click_to_process"));
                list.add("(4/4)");
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        ItemStructureSettings scanSettings = ItemStructureSettings.getSettingsFor(stack);
        if (player.func_70093_af()) {
            scanSettings.clearSettings();
            ItemStructureSettings.setSettingsFor(stack, scanSettings);
        } else if (scanSettings.hasPos1() && scanSettings.hasPos2() && scanSettings.hasBuildKey()) {
            BlockPosition key = scanSettings.key;
            if (player.func_70011_f((double)key.x + 0.5, (double)key.y, (double)key.z + 0.5) > 10.0) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.too_far", new Object[0]));
                return stack;
            }
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.exporting", new Object[0]));
            NetworkHandler.INSTANCE.openGui(player, 1, 0, 0, 0);
        }
        return stack;
    }

    public static boolean scanStructure(World world, BlockPosition pos1, BlockPosition pos2, BlockPosition key, int face, String name, boolean include, NBTTagCompound tag) {
        BlockPosition min = BlockTools.getMin(pos1, pos2);
        BlockPosition max = BlockTools.getMax(pos1, pos2);
        int turns = (6 - face) % 4;
        StructureTemplate template = TemplateScanner.scan(world, min, max, key, turns, name);
        StructureValidationType type = StructureValidationType.getTypeFromName(tag.func_74779_i("validationType"));
        if (type == null) {
            return false;
        }
        StructureValidator validator = type.getValidator();
        if (validator == null) {
            return false;
        }
        validator.readFromNBT(tag);
        template.setValidationSettings(validator);
        if (include) {
            StructureTemplateManager.INSTANCE.addTemplate(template);
        }
        return TemplateExporter.exportTo(template, new File(include ? TemplateLoader.includeDirectory : TemplateLoader.outputDirectory));
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        if (!MinecraftServer.func_71276_C().func_71203_ab().func_152607_e(player.func_146103_bH())) {
            return;
        }
        BlockPosition hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        if (hit == null) {
            return;
        }
        ItemStructureSettings scanSettings = ItemStructureSettings.getSettingsFor(stack);
        if (!scanSettings.hasPos1()) {
            scanSettings.setPos1(hit.x, hit.y, hit.z);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.set_first_pos", new Object[0]));
        } else if (!scanSettings.hasPos2()) {
            scanSettings.setPos2(hit.x, hit.y, hit.z);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.set_second_pos", new Object[0]));
        } else if (!scanSettings.hasBuildKey()) {
            scanSettings.setBuildKey(hit.x, hit.y, hit.z, BlockTools.getPlayerFacingFromYaw(player.field_70177_z));
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.set_offset_pos", new Object[0]));
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.scanner.click_to_process", new Object[0]));
        }
        ItemStructureSettings.setSettingsFor(stack, scanSettings);
    }

    @Override
    public void renderBox(EntityPlayer player, ItemStack stack, float delta) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
        BlockPosition pos1 = settings.hasPos1() ? settings.pos1() : BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        BlockPosition pos2 = settings.hasPos2() ? settings.pos2() : BlockTools.getBlockClickedOn(player, player.field_70170_p, player.func_70093_af());
        if (pos1 != null && pos2 != null) {
            BlockPosition min = BlockTools.getMin(pos1, pos2);
            BlockPosition max = BlockTools.getMax(pos1, pos2);
            IBoxRenderer.Util.renderBoundingBox(player, min, max, delta);
        }
    }
}

