/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public class ItemStructureBuilderWorldGen
extends Item
implements IItemKeyInterface {
    public ItemStructureBuilderWorldGen(String itemName) {
        this.func_77655_b(itemName);
        this.func_77637_a(AWStructuresItemLoader.structureTab);
        this.func_77625_d(1);
        this.func_111206_d("ancientwarfare:structure/structure_builder");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        String structure = "guistrings.structure.no_selection";
        ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(stack);
        if (viewSettings.hasName()) {
            structure = viewSettings.name;
        }
        list.add(StatCollector.func_74838_a((String)"guistrings.current_structure") + " " + StatCollector.func_74838_a((String)structure));
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStructureSettings buildSettings = ItemStructureSettings.getSettingsFor(stack);
        if (buildSettings.hasName()) {
            StructureTemplate template = StructureTemplateManager.INSTANCE.getTemplate(buildSettings.name);
            if (template == null) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("guistrings.template.not_found", new Object[0]));
                return;
            }
            BlockPosition bpHit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (bpHit == null) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("block.not_found", new Object[0]));
                return;
            }
            StructureMap map = AWGameData.INSTANCE.getData(player.field_70170_p, StructureMap.class);
            WorldStructureGenerator.INSTANCE.attemptStructureGenerationAt(player.field_70170_p, bpHit.x, bpHit.y, bpHit.z, BlockTools.getPlayerFacingFromYaw(player.field_70177_z), template, map);
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("guistrings.structure.no_selection", new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af()) {
            NetworkHandler.INSTANCE.openGui(player, 2, 0, 0, 0);
        }
        return stack;
    }
}

