/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.item.AWStructuresItemLoader;
import net.shadowmage.ancientwarfare.structure.item.ItemStructureSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateClient;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManagerClient;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;

public class ItemStructureBuilder
extends Item
implements IItemKeyInterface,
IBoxRenderer {
    public ItemStructureBuilder(String itemName) {
        this.func_77655_b(itemName);
        this.func_77637_a(AWStructuresItemLoader.structureTab);
        this.func_77625_d(1);
        this.func_111206_d("ancientwarfare:structure/" + itemName);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        String structure = "guistrings.structure.no_selection";
        ItemStructureSettings viewSettings = ItemStructureSettings.getSettingsFor(stack);
        if (viewSettings.hasName()) {
            structure = viewSettings.name;
        }
        list.add(StatCollector.func_74838_a((String)"guistrings.current_structure") + " " + StatCollector.func_74838_a((String)structure));
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        return key == IItemKeyInterface.ItemKey.KEY_0;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemKey key) {
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStructureSettings buildSettings = ItemStructureSettings.getSettingsFor(stack);
        if (buildSettings.hasName()) {
            StructureTemplate template = StructureTemplateManager.INSTANCE.getTemplate(buildSettings.name);
            if (template == null) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("guistrings.template.not_found", new Object[0]));
                return;
            }
            BlockPosition bpHit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (bpHit == null) {
                return;
            }
            StructureBuilder builder = new StructureBuilder(player.field_70170_p, template, BlockTools.getPlayerFacingFromYaw(player.field_70177_z), bpHit.x, bpHit.y, bpHit.z);
            builder.instantConstruction();
            if (!player.field_71075_bZ.field_75098_d) {
                int slot = player.field_71071_by.field_70461_c;
                if (stack.field_77994_a == 1) {
                    player.field_71071_by.func_70299_a(slot, null);
                } else {
                    --stack.field_77994_a;
                }
            }
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("guistrings.structure.no_selection", new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
            NetworkHandler.INSTANCE.openGui(player, 2, 0, 0, 0);
        }
        return stack;
    }

    @Override
    public void renderBox(EntityPlayer player, ItemStack stack, float delta) {
        ItemStructureSettings settings = ItemStructureSettings.getSettingsFor(stack);
        if (!settings.hasName()) {
            return;
        }
        String name = settings.name();
        StructureTemplateClient structure = StructureTemplateManagerClient.instance().getClientTemplate(name);
        if (structure == null) {
            return;
        }
        BlockPosition hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        int face = BlockTools.getPlayerFacingFromYaw(player.field_70177_z);
        if (hit == null) {
            return;
        }
        StructureBB bb = new StructureBB(hit.x, hit.y, hit.z, face, structure.xSize, structure.ySize, structure.zSize, structure.xOffset, structure.yOffset, structure.zOffset);
        IBoxRenderer.Util.renderBoundingBox(player, bb.min, bb.max, delta);
    }
}

