/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerPlacer;

public class GuiSpawnerPlacer
extends GuiContainerBase<ContainerSpawnerPlacer> {
    private Label currentSelectionName;
    private CompositeScrolled typeSelectionArea;
    private CompositeScrolled attributesArea;
    private final HashMap<Label, String> labelToClass = new HashMap();

    public GuiSpawnerPlacer(ContainerBase par1Container) {
        super(par1Container);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerSpawnerPlacer)((Object)this.getContainer())).sendDataToServer();
        return true;
    }

    @Override
    public void initElements() {
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiSpawnerPlacer.this.closeGui();
            }
        };
        this.addGuiElement(button);
        this.addGuiElement(new Label(8, 8, "guistrings.current_selection"));
        this.currentSelectionName = new Label(8, 18, "");
        this.updateSelectionName();
        this.addGuiElement(this.currentSelectionName);
        this.typeSelectionArea = new CompositeScrolled(this, 0, 30, 256, 105);
        this.addGuiElement(this.typeSelectionArea);
        this.attributesArea = new CompositeScrolled(this, 0, 135, 256, 105);
        this.addGuiElement(this.attributesArea);
    }

    @Override
    public void setupElements() {
        Label label;
        this.typeSelectionArea.clearElements();
        this.attributesArea.clearElements();
        this.labelToClass.clear();
        int totalHeight = 3;
        Set mp = EntityList.field_75625_b.keySet();
        Listener listener = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).entityId = (String)GuiSpawnerPlacer.this.labelToClass.get(widget);
                    GuiSpawnerPlacer.this.updateSelectionName();
                }
                return true;
            }
        };
        for (String name : mp) {
            if (AWStructureStatics.excludedSpawnerEntities.contains(name)) continue;
            label = new Label(8, totalHeight, "entity." + name + ".name");
            label.addNewListener(listener);
            this.typeSelectionArea.addGuiElement(label);
            this.labelToClass.put(label, name);
            totalHeight += 12;
        }
        this.typeSelectionArea.setAreaSize(totalHeight);
        this.updateSelectionName();
        totalHeight = 3;
        label = new Label(8, totalHeight, "guistrings.spawner.delay");
        this.attributesArea.addGuiElement(label);
        NumberInput input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).delay, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)GuiSpawnerPlacer.this.field_147002_h).delay = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.min_spawn_delay");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).minSpawnDelay, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).minSpawnDelay = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.max_spawn_delay");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).maxSpawnDelay, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).maxSpawnDelay = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.spawn_count");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).spawnCount, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).spawnCount = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.max_nearby_entities");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).maxNearbyEntities, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).maxNearbyEntities = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.required_player_range");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).requiredPlayerRange, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).requiredPlayerRange = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        label = new Label(8, totalHeight += 12, "guistrings.spawner.spawn_range");
        this.attributesArea.addGuiElement(label);
        input = new NumberInput(120, totalHeight, 112, ((ContainerSpawnerPlacer)((Object)this.getContainer())).spawnRange, this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerSpawnerPlacer)((Object)GuiSpawnerPlacer.this.getContainer())).spawnRange = (short)value;
            }
        };
        input.setIntegerValue();
        this.attributesArea.addGuiElement(input);
        this.attributesArea.setAreaSize(totalHeight += 12);
    }

    private void updateSelectionName() {
        this.currentSelectionName.setText("entity." + ((ContainerSpawnerPlacer)((Object)this.getContainer())).entityId + ".name");
    }
}

