/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.structure.item.ItemSpawnerPlacer;

public class ContainerSpawnerPlacer
extends ContainerBase {
    public String entityId;
    public int delay;
    public int minSpawnDelay;
    public int maxSpawnDelay;
    public int spawnCount;
    public int maxNearbyEntities;
    public int requiredPlayerRange;
    public int spawnRange;

    public ContainerSpawnerPlacer(EntityPlayer player, int x, int y, int z) {
        super(player);
        ItemStack stack = player.func_70694_bm();
        if (this.isInValid(stack)) {
            throw new IllegalArgumentException("Incorrect held item");
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("spawnerData")) {
            this.entityId = "Pig";
            this.delay = 20;
            this.minSpawnDelay = 800;
            this.maxSpawnDelay = 800;
            this.spawnCount = 4;
            this.maxNearbyEntities = 6;
            this.requiredPlayerRange = 16;
            this.spawnRange = 4;
        } else {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("spawnerData");
            this.entityId = tag.func_74779_i("EntityId");
            this.delay = tag.func_74765_d("Delay");
            this.minSpawnDelay = tag.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = tag.func_74765_d("MaxSpawnDelay");
            this.spawnCount = tag.func_74765_d("SpawnCount");
            this.maxNearbyEntities = tag.func_74765_d("MaxNearbyEntities");
            this.requiredPlayerRange = tag.func_74765_d("RequiredPlayerRange");
            this.spawnRange = tag.func_74765_d("SpawnRange");
        }
        this.addPlayerSlots();
        this.removeSlots();
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("spawnerData")) {
            ItemStack stack = this.player.func_70694_bm();
            if (this.isInValid(stack)) {
                return;
            }
            stack.func_77983_a("spawnerData", (NBTBase)tag.func_74775_l("spawnerData"));
            this.func_75142_b();
        }
    }

    public void sendDataToServer() {
        NBTTagCompound tag2 = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("EntityId", this.entityId);
        tag.func_74777_a("Delay", (short)this.delay);
        tag.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        tag.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        tag.func_74777_a("SpawnCount", (short)this.spawnCount);
        tag.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        tag.func_74777_a("RequiredPlayerRange", (short)this.requiredPlayerRange);
        tag.func_74777_a("SpawnRange", (short)this.spawnRange);
        tag2.func_74782_a("spawnerData", (NBTBase)tag);
        this.sendDataToServer(tag2);
    }

    private boolean isInValid(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemSpawnerPlacer);
    }
}

