/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class POTradeTransferEntry {
    private TransferType type = this.getDefaultType();
    private ItemStack filter;

    protected abstract TransferType getDefaultType();

    public abstract void toggleType();

    protected abstract TransferType getTypeFrom(int var1);

    public final ItemStack getFilter() {
        return this.filter;
    }

    public final void setFilter(ItemStack stack) {
        this.filter = stack;
    }

    public final void setType(TransferType type) {
        this.type = type == null ? this.getDefaultType() : type;
    }

    public final TransferType getType() {
        return this.type;
    }

    public final void process(IInventory storage, IInventory move, int side) {
        if (this.filter != null) {
            this.type.doTransfer(storage, move, side, this.filter);
        }
    }

    public final void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("item")) {
            this.filter = InventoryTools.readItemStack(tag.func_74775_l("item"));
        }
        this.type = this.getTypeFrom(tag.func_74762_e("type"));
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.filter != null) {
            tag.func_74782_a("item", (NBTBase)InventoryTools.writeItemStack(this.filter));
        }
        tag.func_74768_a("type", this.type.ordinal());
        return tag;
    }

    public static interface TransferType {
        public void doTransfer(IInventory var1, IInventory var2, int var3, ItemStack var4);

        public int ordinal();
    }
}

