/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.item.ItemOrders;
import org.lwjgl.opengl.GL11;

public final class RenderWorkLines {
    public static final RenderWorkLines INSTANCE = new RenderWorkLines();
    private final List<BlockPosition> positionList = new ArrayList<BlockPosition>();

    private RenderWorkLines() {
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent evt) {
        boolean render = AWNPCStatics.renderWorkPoints.getBoolean();
        if (!render) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (item instanceof ItemOrders) {
            this.positionList.addAll(((ItemOrders)item).getPositionsForRender(stack));
        }
        if (this.positionList.size() > 0) {
            this.renderListOfPoints((EntityPlayer)player, evt.partialTicks);
            this.positionList.clear();
        }
    }

    private void renderListOfPoints(EntityPlayer player, float partialTick) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        BlockPosition prev = null;
        int index = 1;
        for (BlockPosition point : this.positionList) {
            bb.func_72324_b(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            bb.func_72317_d((double)point.x, (double)point.y, (double)point.z);
            bb = RenderTools.adjustBBForPlayerPos(bb, player, partialTick);
            RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 1.0f, 1.0f);
            this.renderTextAt(player, (double)point.x + 0.5, (double)point.y + 1.5, (double)point.z + 0.5, String.valueOf(index), partialTick);
            if (prev != null) {
                this.renderLineBetween(player, (double)point.x + 0.5, (double)point.y + 0.5, (double)point.z + 0.5, (double)prev.x + 0.5, (double)prev.y + 0.5, (double)prev.z + 0.5, partialTick);
            }
            prev = point;
            ++index;
        }
    }

    private void renderLineBetween(EntityPlayer player, double x1, double y1, double z1, double x2, double y2, double z2, float partialTick) {
        double ox = RenderTools.getRenderOffsetX(player, partialTick);
        double oy = RenderTools.getRenderOffsetY(player, partialTick);
        double oz = RenderTools.getRenderOffsetZ(player, partialTick);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(x1 - ox), (double)(y1 - oy), (double)(z1 - oz));
        GL11.glVertex3d((double)(x2 - ox), (double)(y2 - oy), (double)(z2 - oz));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void renderTextAt(EntityPlayer player, double x, double y, double z, String text, float partialTick) {
        double ox = RenderTools.getRenderOffsetX(player, partialTick);
        double oy = RenderTools.getRenderOffsetY(player, partialTick);
        double oz = RenderTools.getRenderOffsetZ(player, partialTick);
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)(x -= ox)), (float)((float)(y -= oy)), (float)((float)(z -= oz)));
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 0, 0, -1);
        GL11.glPopMatrix();
    }
}

