/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.npc.item.ItemCommandBaton;

public final class RenderCommandOverlay {
    public static final RenderCommandOverlay INSTANCE = new RenderCommandOverlay();
    private List<Entity> targetEntities = Collections.emptyList();
    private MovingObjectPosition target;
    private String targetString;

    private RenderCommandOverlay() {
    }

    public MovingObjectPosition getClientTarget() {
        return this.target;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || mc.field_71462_r != null || mc.field_71439_g.func_71045_bC() == null || !(mc.field_71439_g.func_71045_bC().func_77973_b() instanceof ItemCommandBaton)) {
            return;
        }
        if (evt.phase == TickEvent.Phase.START) {
            this.target = RayTraceUtils.getPlayerTarget((EntityPlayer)mc.field_71439_g, 120.0f, 0.0f);
            if (this.target != null) {
                if (this.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    this.targetString = this.target.field_72311_b + "," + this.target.field_72312_c + "," + this.target.field_72309_d;
                } else if (this.target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    this.targetString = this.target.field_72308_g.func_70005_c_();
                }
            }
            this.targetEntities = ItemCommandBaton.getCommandedEntities((World)mc.field_71441_e, mc.field_71439_g.func_71045_bC());
        } else if (!mc.field_71474_y.field_74330_P) {
            ArrayList<String> entityNames = new ArrayList<String>();
            for (Entity e : this.targetEntities) {
                entityNames.add(e.func_70005_c_());
            }
            ScaledResolution sr = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int x = sr.func_78326_a() - 10;
            String header = StatCollector.func_74838_a((String)"guistrings.npc.target");
            mc.field_71466_p.func_78261_a(header, x - mc.field_71466_p.func_78256_a(header), 0, -1);
            if (this.targetString != null) {
                mc.field_71466_p.func_78261_a(this.targetString, x - mc.field_71466_p.func_78256_a(this.targetString), 10, -1);
            }
            mc.field_71466_p.func_78261_a(StatCollector.func_74838_a((String)"guistrings.npc.commanded"), 10, 0, -1);
            for (int i = 0; i < entityNames.size(); ++i) {
                mc.field_71466_p.func_78261_a((String)entityNames.get(i), 10, 10 + 10 * i, -1);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent evt) {
        AxisAlignedBB bb;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71462_r != null || mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71439_g.func_71045_bC() == null || !(mc.field_71439_g.func_71045_bC().func_77973_b() instanceof ItemCommandBaton)) {
            return;
        }
        MovingObjectPosition pos = this.target;
        if (pos != null) {
            bb = null;
            if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                bb = AxisAlignedBB.func_72330_a((double)pos.field_72311_b, (double)pos.field_72312_c, (double)pos.field_72309_d, (double)((double)pos.field_72311_b + 1.0), (double)((double)pos.field_72312_c + 1.0), (double)((double)pos.field_72309_d + 1.0)).func_72314_b(0.1, 0.1, 0.1);
            } else if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && pos.field_72308_g.field_70121_D != null && pos.field_72308_g instanceof EntityLivingBase) {
                bb = pos.field_72308_g.field_70121_D.func_72329_c();
                Entity e = pos.field_72308_g;
                float t = 1.0f - evt.partialTicks;
                double dx = e.field_70165_t - e.field_70142_S;
                double dy = e.field_70163_u - e.field_70137_T;
                double dz = e.field_70161_v - e.field_70136_U;
                bb.func_72317_d((double)t * -dx, (double)t * -dy, (double)t * -dz);
            }
            if (bb != null) {
                bb = RenderTools.adjustBBForPlayerPos(bb, (EntityPlayer)mc.field_71439_g, evt.partialTicks);
                RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 1.0f, 1.0f);
            }
        }
        bb = null;
        for (Entity e : this.targetEntities) {
            if (e.field_70121_D == null) continue;
            bb = e.field_70121_D.func_72329_c();
            float t = 1.0f - evt.partialTicks;
            double dx = e.field_70165_t - e.field_70142_S;
            double dy = e.field_70163_u - e.field_70137_T;
            double dz = e.field_70161_v - e.field_70136_U;
            bb.func_72317_d((double)t * -dx, (double)t * -dy, (double)t * -dz);
            bb = RenderTools.adjustBBForPlayerPos(bb, (EntityPlayer)mc.field_71439_g, evt.partialTicks);
            RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 0.0f, 0.0f);
        }
    }
}

