/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.faction;

import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;

public final class FactionEntry {
    public final String playerName;
    private HashMap<String, FactionStanding> factionStandings = new HashMap();

    public FactionEntry(NBTTagCompound tag) {
        this.playerName = tag.func_74779_i("playerName");
        for (String name : AWNPCStatics.factionNames) {
            this.factionStandings.put(name, new FactionStanding(AncientWarfareNPC.statics.getDefaultFaction(name)));
        }
        this.readFromNBT(tag);
    }

    public FactionEntry(String playerName) {
        this.playerName = playerName;
        for (String name : AWNPCStatics.factionNames) {
            this.factionStandings.put(name, new FactionStanding(AncientWarfareNPC.statics.getDefaultFaction(name)));
        }
    }

    public int getStandingFor(String factionName) {
        if (this.factionStandings.containsKey(factionName)) {
            return this.factionStandings.get((Object)factionName).standing;
        }
        return 0;
    }

    public void setStandingFor(String factionName, int standing) {
        if (!this.factionStandings.containsKey(factionName)) {
            this.factionStandings.put(factionName, new FactionStanding(standing));
        }
        this.factionStandings.get((Object)factionName).standing = standing;
    }

    public void adjustStandingFor(String factionName, int adjustment) {
        if (this.factionStandings.containsKey(factionName)) {
            FactionStanding standing = this.factionStandings.get(factionName);
            standing.standing += adjustment;
        }
    }

    public final void readFromNBT(NBTTagCompound tag) {
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            String name = entryTag.func_74779_i("name");
            if (!this.factionStandings.containsKey(name)) {
                this.factionStandings.put(name, new FactionStanding(AncientWarfareNPC.statics.getDefaultFaction(name)));
            }
            this.factionStandings.get((Object)name).standing = entryTag.func_74762_e("standing");
        }
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("playerName", this.playerName);
        NBTTagList entryList = new NBTTagList();
        for (String name : this.factionStandings.keySet()) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("name", name);
            entryTag.func_74768_a("standing", this.factionStandings.get((Object)name).standing);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
        return tag;
    }

    private static class FactionStanding {
        int standing;

        private FactionStanding(int standing) {
            this.standing = standing;
        }
    }
}

