/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcCourier;
import net.shadowmage.ancientwarfare.npc.orders.RoutingOrder;

public class NpcAIPlayerOwnedCourier
extends NpcAI<NpcCourier> {
    boolean init;
    int routeIndex;
    int ticksToWork;
    int ticksAtSite;
    RoutingOrder order;
    ItemStack routeStack;

    public NpcAIPlayerOwnedCourier(NpcCourier npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.init) {
            this.init = true;
            this.routeStack = ((NpcCourier)this.npc).ordersStack;
            this.order = RoutingOrder.getRoutingOrder(this.routeStack);
            if (this.order != null && this.routeIndex >= this.order.size() || this.order == null) {
                this.routeIndex = 0;
            }
        }
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        if (!((NpcCourier)this.npc).getIsAIEnabled() || ((NpcCourier)this.npc).shouldBeAtHome()) {
            return false;
        }
        return ((NpcCourier)this.npc).backpackInventory != null && this.order != null && !this.order.isEmpty();
    }

    public void func_75249_e() {
        ((NpcCourier)this.npc).addAITask(16);
    }

    public void func_75246_d() {
        BlockPosition pos = ((RoutingOrder.RoutePoint)this.order.get(this.routeIndex)).getTarget();
        double dist = ((NpcCourier)this.npc).func_70092_e(pos.x, pos.y, pos.z);
        if (dist > 25.0) {
            ((NpcCourier)this.npc).addAITask(512);
            this.ticksAtSite = 0;
            this.ticksToWork = 0;
            this.moveToPosition(pos, dist);
        } else {
            this.moveRetryDelay = 0;
            ((NpcCourier)this.npc).func_70661_as().func_75499_g();
            ((NpcCourier)this.npc).removeAITask(512);
            this.workAtSite();
        }
    }

    public void func_75251_c() {
        this.ticksToWork = 0;
        this.ticksAtSite = 0;
        this.moveRetryDelay = 0;
        ((NpcCourier)this.npc).func_70661_as().func_75499_g();
        ((NpcCourier)this.npc).removeAITask(528);
    }

    public void workAtSite() {
        if (this.ticksToWork == 0) {
            this.startWork();
        } else {
            ++this.ticksAtSite;
            if (((NpcCourier)this.npc).field_70173_aa % 10 == 0) {
                ((NpcCourier)this.npc).func_71038_i();
            }
            if (this.ticksAtSite > this.ticksToWork) {
                this.setMoveToNextSite();
            }
        }
    }

    private void startWork() {
        IInventory target = this.getTargetInventory();
        if (target != null) {
            this.ticksAtSite = 0;
            int moved = this.order.handleRouteAction((RoutingOrder.RoutePoint)this.order.get(this.routeIndex), (IInventory)((NpcCourier)this.npc).backpackInventory, target);
            ((NpcCourier)this.npc).updateBackpackItemContents();
            if (moved > 0) {
                this.ticksToWork = (AWNPCStatics.npcWorkTicks - ((NpcCourier)this.npc).getLevelingStats().getLevel()) * moved;
                if (this.ticksToWork <= 0) {
                    this.ticksToWork = 0;
                }
                ((NpcCourier)this.npc).addExperience(moved * AWNPCStatics.npcXpFromMoveItem);
                return;
            }
        }
        this.setMoveToNextSite();
    }

    private IInventory getTargetInventory() {
        BlockPosition pos = ((RoutingOrder.RoutePoint)this.order.get(this.routeIndex)).getTarget();
        TileEntity te = ((NpcCourier)this.npc).field_70170_p.func_147438_o(pos.x, pos.y, pos.z);
        if (te instanceof IInventory) {
            String name;
            if (te instanceof IOwnable && (name = ((IOwnable)te).getOwnerName()) != null && !((NpcCourier)this.npc).canBeCommandedBy(name)) {
                return null;
            }
            return (IInventory)te;
        }
        return null;
    }

    public void setMoveToNextSite() {
        this.ticksAtSite = 0;
        this.ticksToWork = 0;
        this.moveRetryDelay = 0;
        ++this.routeIndex;
        if (this.routeIndex >= this.order.size()) {
            this.routeIndex = 0;
        }
    }

    public void onOrdersChanged() {
        this.routeStack = ((NpcCourier)this.npc).ordersStack;
        this.order = RoutingOrder.getRoutingOrder(this.routeStack);
        this.routeIndex = 0;
        this.ticksAtSite = 0;
        this.ticksToWork = 0;
        this.moveRetryDelay = 0;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.routeIndex = tag.func_74762_e("routeIndex");
        this.ticksAtSite = tag.func_74762_e("ticksAtSite");
        this.ticksToWork = tag.func_74762_e("ticksToWork");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("routeIndex", this.routeIndex);
        tag.func_74768_a("ticksAtSite", this.ticksAtSite);
        tag.func_74768_a("ticksToWork", this.ticksToWork);
        return tag;
    }
}

