/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBard;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIPlayerOwnedBard
extends NpcAI {
    private boolean playing = false;
    private int currentDelay;
    private int tuneIndex = -1;
    private int playerCheckDelay;
    private int playTime;
    private int maxPlayTime;
    private NpcBard bard;

    public NpcAIPlayerOwnedBard(NpcBase npc) {
        super(npc);
        this.bard = (NpcBard)npc;
    }

    public boolean func_75250_a() {
        return this.npc.getIsAIEnabled() && this.bard.getTuneData().size() > 0;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        SongPlayData data = this.bard.getTuneData();
        if (this.playing) {
            ++this.playTime;
            if (this.playTime >= this.maxPlayTime) {
                this.playTime = 0;
                this.playing = false;
                int d = data.getMaxDelay() - data.getMinDelay();
                this.currentDelay = data.getMinDelay() + (d > 0 ? this.npc.func_70681_au().nextInt(d) : 0);
            }
        } else if (this.currentDelay > 0) {
            --this.currentDelay;
        } else if (data.getPlayOnPlayerEntry()) {
            --this.playerCheckDelay;
            if (this.playerCheckDelay <= 0) {
                this.playerCheckDelay = 10;
                AxisAlignedBB aabb = this.npc.field_70121_D.func_72329_c().func_72314_b(20.0, 20.0, 20.0);
                List list = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
                if (list != null && !list.isEmpty()) {
                    this.setNextSong();
                    this.startSong();
                }
            }
        } else {
            this.setNextSong();
            this.startSong();
        }
    }

    private void setNextSong() {
        SongPlayData data = this.bard.getTuneData();
        ++this.tuneIndex;
        if (this.tuneIndex >= data.size()) {
            this.tuneIndex = 0;
        }
    }

    private void startSong() {
        SongPlayData data = this.bard.getTuneData();
        SongPlayData.SongEntry entry = data.get(this.tuneIndex);
        this.maxPlayTime = (int)(entry.length() * 20.0f * 60.0f);
        float volume = (float)entry.volume() * 0.03f;
        this.bard.field_70170_p.func_72956_a((Entity)this.bard, entry.name(), volume, 1.0f);
        this.playing = true;
        this.playTime = 0;
    }
}

