/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.npc.ai.PathFind;

public class NpcNavigator
extends PathNavigate {
    private final EntityLiving entity;
    private boolean swim;
    private boolean doors = true;

    public NpcNavigator(EntityLiving living) {
        super(living, living.field_70170_p);
        this.entity = living;
    }

    public void func_75495_e(boolean value) {
        super.func_75495_e(value);
        this.swim = value;
    }

    public void func_75490_c(boolean value) {
        super.func_75490_c(value);
        this.doors = value;
    }

    public void onWorldChange() {
        this.field_75513_b = this.entity.field_70170_p;
    }

    public PathEntity func_75488_a(double posX, double posY, double posZ) {
        return !this.func_75485_k() ? null : this.pathToXYZ(MathHelper.func_76128_c((double)posX), (int)posY, MathHelper.func_76128_c((double)posZ));
    }

    public PathEntity func_75494_a(Entity target) {
        return !this.func_75485_k() ? null : this.pathToEntity(target);
    }

    public boolean func_75484_a(PathEntity path, double speed) {
        if (this.hasMount()) {
            ((EntityLiving)this.entity.field_70154_o).func_70661_as().func_75484_a(path, speed);
        }
        return super.func_75484_a(path, speed);
    }

    public void func_75499_g() {
        if (this.hasMount()) {
            ((EntityLiving)this.entity.field_70154_o).func_70661_as().func_75499_g();
        }
        super.func_75499_g();
    }

    public void func_75501_e() {
        super.func_75501_e();
        if (!this.func_75500_f() && this.hasMount()) {
            ((EntityLiving)this.entity.field_70154_o).func_70661_as().func_75501_e();
        }
    }

    private boolean hasMount() {
        return this.entity.field_70154_o instanceof EntityLiving;
    }

    private Entity mountOrEntity() {
        return this.hasMount() ? this.entity.field_70154_o : this.entity;
    }

    private PathEntity pathToEntity(Entity target) {
        ChunkCache chunkcache = this.cachePath(1, 16);
        PathEntity pathentity = new PathFind((IBlockAccess)chunkcache, this.doors, this.func_75507_c(), this.func_75486_a(), this.swim).func_75856_a(this.mountOrEntity(), target, this.func_111269_d());
        this.field_75513_b.field_72984_F.func_76319_b();
        return pathentity;
    }

    private PathEntity pathToXYZ(int x, int y, int z) {
        ChunkCache chunkcache = this.cachePath(0, 8);
        PathEntity pathentity = new PathFind((IBlockAccess)chunkcache, this.doors, this.func_75507_c(), this.func_75486_a(), this.swim).func_75859_a(this.mountOrEntity(), x, y, z, this.func_111269_d());
        this.field_75513_b.field_72984_F.func_76319_b();
        return pathentity;
    }

    private ChunkCache cachePath(int h, int r) {
        this.field_75513_b.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)this.entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(this.entity.field_70163_u + (double)h));
        int k = MathHelper.func_76128_c((double)this.entity.field_70161_v);
        int l = (int)(this.func_111269_d() + (float)r);
        return new ChunkCache(this.field_75513_b, i - l, j - l, k - l, i + l, j + l, k + l, 0);
    }

    protected boolean func_75485_k() {
        return super.func_75485_k() || this.hasMount();
    }

    protected boolean func_75483_a(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, Vec3 origin, double vecX, double vecZ) {
        int k1 = xOffset - xSize / 2;
        int l1 = zOffset - zSize / 2;
        if (!this.func_75496_b(k1, yOffset, l1, xSize, ySize, zSize, origin, vecX, vecZ)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + xSize; ++i2) {
            for (int j2 = l1; j2 < l1 + zSize; ++j2) {
                double d2 = (double)i2 + 0.5 - origin.field_72450_a;
                double d3 = (double)j2 + 0.5 - origin.field_72449_c;
                if (!(d2 * vecX + d3 * vecZ >= 0.0)) continue;
                Material material = this.field_75513_b.func_147439_a(i2, yOffset - 1, j2).func_149688_o();
                if (material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151581_o || material == Material.field_151570_A) {
                    return false;
                }
                if (material != Material.field_151586_h || this.entity.func_70090_H()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String result = this.func_75500_f() ? "No Path " + (this.func_75505_d() != null ? Integer.valueOf(this.func_75505_d().func_75874_d()) : "") : "Path to " + this.func_75505_d().func_75877_a(this.func_75505_d().func_75873_e()).toString();
        if (this.hasMount() && !((EntityLiving)this.entity.field_70154_o).func_70661_as().func_75500_f()) {
            PathEntity path = ((EntityLiving)this.entity.field_70154_o).func_70661_as().func_75505_d();
            result = result + "AND Mount path to " + path.func_75877_a(path.func_75873_e()).toString();
        }
        return result;
    }
}

