/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.research;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;

public class ResearchData
extends WorldSavedData {
    private HashMap<String, ResearchEntry> playerResearchEntries = new HashMap();

    public ResearchData(String par1Str) {
        super(par1Str);
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (!this.playerResearchEntries.containsKey(player.func_70005_c_())) {
            this.playerResearchEntries.put(player.func_70005_c_(), new ResearchEntry());
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.playerResearchEntries.clear();
        NBTTagList entryList = tag.func_150295_c("entryList", 10);
        for (int i = 0; i < entryList.func_74745_c(); ++i) {
            ResearchEntry entry = new ResearchEntry();
            NBTTagCompound entryTag = entryList.func_150305_b(i);
            String name = entryTag.func_74779_i("playerName");
            entry.readFromNBT(entryTag);
            this.playerResearchEntries.put(name, entry);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList entryList = new NBTTagList();
        for (String name : this.playerResearchEntries.keySet()) {
            ResearchEntry entry = this.playerResearchEntries.get(name);
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74778_a("playerName", name);
            entry.writeToNBT(entryTag);
            entryList.func_74742_a((NBTBase)entryTag);
        }
        tag.func_74782_a("entryList", (NBTBase)entryList);
    }

    public void removeResearchFrom(String playerName, int research) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).removeResearch(research);
        }
    }

    public void clearResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).clearResearch();
        }
    }

    public void fillResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).fillResearch();
        }
    }

    public Set<Integer> getResearchableGoals(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            ResearchEntry entry = this.playerResearchEntries.get(playerName);
            return ResearchGoal.getResearchableGoalsFor(entry.completedResearch, entry.queuedResearch, entry.currentResearch);
        }
        return Collections.emptySet();
    }

    public Set<Integer> getResearchFor(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).completedResearch;
        }
        return Collections.emptySet();
    }

    public void addResearchTo(String playerName, int research) {
        if (!this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.put(playerName, new ResearchEntry());
        }
        this.playerResearchEntries.get(playerName).addResearch(research);
        this.func_76185_a();
    }

    public boolean hasPlayerCompletedResearch(String playerName, int research) {
        return this.playerResearchEntries.containsKey(playerName) && this.playerResearchEntries.get(playerName).knowsResearch(research);
    }

    public int getInProgressResearch(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getInProgressResearch();
        }
        return -1;
    }

    public int getResearchProgress(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getResearchProgress();
        }
        return 0;
    }

    public void startResearch(String playerName, int goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).startResearch(goal);
            this.func_76185_a();
        }
    }

    public void finishResearch(String playerName, int goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).finishResearch(goal);
            this.func_76185_a();
        }
    }

    public void setCurrentResearchProgress(String playerName, int progress) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).setResearchProgress(progress);
            this.func_76185_a();
        }
    }

    public void addQueuedResearch(String playerName, int goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).addQueuedResearch(goal);
        }
    }

    public void removeQueuedResearch(String playerName, int goal) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            this.playerResearchEntries.get(playerName).removeQueuedResearch(goal);
            this.func_76185_a();
        }
    }

    public List<Integer> getQueuedResearch(String playerName) {
        if (this.playerResearchEntries.containsKey(playerName)) {
            return this.playerResearchEntries.get(playerName).getResearchQueue();
        }
        return Collections.emptyList();
    }

    public boolean addProgress(String playerName, int amount) {
        return this.playerResearchEntries.containsKey(playerName) && this.playerResearchEntries.get(playerName).addProgress(amount);
    }

    public boolean hasResearchStarted(String playerName) {
        return this.playerResearchEntries.containsKey(playerName) && this.playerResearchEntries.get(playerName).hasResearchStarted();
    }

    private static final class ResearchEntry {
        private int currentResearch = -1;
        private int currentProgress = -1;
        private Set<Integer> completedResearch = new HashSet<Integer>();
        private List<Integer> queuedResearch = new ArrayList<Integer>();

        private ResearchEntry() {
        }

        private boolean knowsResearch(int num) {
            return this.completedResearch.contains(num);
        }

        public boolean addProgress(int amount) {
            if (this.currentResearch >= 0) {
                this.currentProgress += amount;
                if (this.currentProgress >= ResearchGoal.getGoal(this.currentResearch).getTotalResearchTime()) {
                    this.finishResearch(this.currentResearch);
                }
                return true;
            }
            return false;
        }

        public void finishResearch(int goal) {
            if (goal == this.currentResearch) {
                this.completedResearch.add(goal);
                this.currentProgress = -1;
                this.currentResearch = -1;
            }
        }

        public void startResearch(int goal) {
            if (this.currentResearch >= 0 || !this.queuedResearch.contains(goal)) {
                return;
            }
            this.queuedResearch.remove((Object)goal);
            this.currentResearch = goal;
            this.currentProgress = 0;
        }

        public boolean hasResearchStarted() {
            return this.currentProgress >= 0 && this.currentResearch >= 0;
        }

        private void setResearchProgress(int progress) {
            this.currentProgress = progress;
        }

        private int getResearchProgress() {
            return this.currentProgress;
        }

        private int getInProgressResearch() {
            return this.currentResearch;
        }

        private void addResearch(int num) {
            this.completedResearch.add(num);
            if (this.queuedResearch.contains(num)) {
                this.queuedResearch.remove((Object)num);
            }
            if (this.currentResearch == num) {
                this.currentResearch = -1;
                this.currentProgress = -1;
            }
        }

        private void removeResearch(int num) {
            this.completedResearch.remove(num);
        }

        private void clearResearch() {
            this.completedResearch.clear();
            this.currentProgress = -1;
            this.currentResearch = -1;
            this.queuedResearch.clear();
        }

        private void fillResearch() {
            this.completedResearch.clear();
            this.currentProgress = -1;
            this.currentResearch = -1;
            this.queuedResearch.clear();
            for (ResearchGoal g : ResearchGoal.getResearchGoals()) {
                this.completedResearch.add(g.getId());
            }
        }

        private void addQueuedResearch(int num) {
            if (!this.queuedResearch.contains(num)) {
                this.queuedResearch.add(num);
            }
        }

        private List<Integer> getResearchQueue() {
            return this.queuedResearch;
        }

        private void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("currentResearch", this.currentResearch);
            tag.func_74768_a("currentProgress", this.currentProgress);
            int[] completedGoals = new int[this.completedResearch.size()];
            int index = 0;
            for (Integer i : this.completedResearch) {
                completedGoals[index] = i;
                ++index;
            }
            tag.func_74783_a("completedResearch", completedGoals);
            int[] queuedGoals = new int[this.queuedResearch.size()];
            index = 0;
            for (Integer i : this.queuedResearch) {
                queuedGoals[index] = i;
                ++index;
            }
            tag.func_74783_a("queuedResearch", queuedGoals);
        }

        private void readFromNBT(NBTTagCompound tag) {
            int[] in;
            this.currentResearch = tag.func_74762_e("currentResearch");
            this.currentProgress = tag.func_74762_e("currentProgress");
            for (int k : in = tag.func_74759_k("completedResearch")) {
                this.completedResearch.add(k);
            }
            for (int k : in = tag.func_74759_k("queuedResearch")) {
                this.queuedResearch.add(k);
            }
        }

        private void removeQueuedResearch(Integer goal) {
            Integer exam;
            if (!this.queuedResearch.contains(goal)) {
                return;
            }
            ArrayList<Integer> goalsToValidate = new ArrayList<Integer>();
            Iterator<Integer> it = this.queuedResearch.iterator();
            boolean found = false;
            while (it.hasNext() && (exam = it.next()) != null) {
                if (found) {
                    goalsToValidate.add(exam);
                    it.remove();
                    continue;
                }
                if (!exam.equals(goal)) continue;
                found = true;
                it.remove();
            }
            HashSet<Integer> totalResearch = new HashSet<Integer>();
            totalResearch.addAll(this.completedResearch);
            totalResearch.addAll(this.queuedResearch);
            if (this.currentResearch >= 0) {
                totalResearch.add(this.currentResearch);
            }
            for (Integer g1 : goalsToValidate) {
                ResearchGoal g = ResearchGoal.getGoal(g1);
                if (g == null || !g.canResearch(totalResearch)) continue;
                totalResearch.add(g1);
                this.queuedResearch.add(g1);
            }
        }
    }
}

