/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shadowmage.ancientwarfare.core.model.ModelBaseAW;
import net.shadowmage.ancientwarfare.core.model.Primitive;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import org.lwjgl.opengl.GL11;

public class ModelPiece {
    private String pieceName;
    private boolean visible = true;
    private float x;
    private float y;
    private float z;
    private float rx;
    private float ry;
    private float rz;
    private Set<ModelPiece> children = new HashSet<ModelPiece>();
    private List<Primitive> primitives = new ArrayList<Primitive>();
    private ModelPiece parent;
    boolean compiled = false;
    int displayList = -1;

    public ModelPiece(ModelBaseAW model, String line) {
        String[] bits = line.split(",");
        this.pieceName = bits[0];
        String parentName = bits[1];
        float x = StringTools.safeParseFloat(bits[2]);
        float y = StringTools.safeParseFloat(bits[3]);
        float z = StringTools.safeParseFloat(bits[4]);
        float rx = StringTools.safeParseFloat(bits[5]);
        float ry = StringTools.safeParseFloat(bits[6]);
        float rz = StringTools.safeParseFloat(bits[7]);
        ModelPiece parent = parentName.equals("null") ? null : model.getPiece(parentName);
        this.setPosition(x, y, z);
        this.setRotation(rx, ry, rz);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void setVisible(boolean val) {
        this.visible = val;
    }

    public ModelPiece(String name, float x, float y, float z, float rx, float ry, float rz, ModelPiece parent) {
        this.pieceName = name;
        this.setPosition(x, y, z);
        this.setRotation(rx, ry, rz);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void clearParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public ModelPiece setParent(ModelPiece parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (parent != null) {
            parent.addChild(this);
        }
        return this;
    }

    public ModelPiece copy() {
        ModelPiece piece = new ModelPiece(this.pieceName + "_copy", this.x, this.y, this.z, this.rx, this.ry, this.rz, this.parent);
        for (Primitive primitive : this.primitives) {
            piece.addPrimitive(primitive.copy());
        }
        return piece;
    }

    public ModelPiece getParent() {
        return this.parent;
    }

    public boolean isBasePiece() {
        return this.getParent() == null;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float rx() {
        return this.rx;
    }

    public float ry() {
        return this.ry;
    }

    public float rz() {
        return this.rz;
    }

    public String getName() {
        return this.pieceName;
    }

    public Collection<ModelPiece> getChildren() {
        return this.children;
    }

    public void setRotation(float rx, float ry, float rz) {
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public void recompilePiece() {
        this.compiled = false;
        for (ModelPiece p : this.children) {
            p.recompilePiece();
        }
    }

    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setName(String name) {
        this.pieceName = name;
    }

    public void addPrimitive(Primitive primitive) {
        this.primitives.add(primitive);
        primitive.parent = this;
    }

    public void removePrimitive(Primitive primitive) {
        this.primitives.remove(primitive);
        primitive.parent = null;
    }

    public void addChild(ModelPiece piece) {
        this.children.add(piece);
        piece.parent = this;
    }

    public void removeChild(ModelPiece piece) {
        this.children.remove(piece);
        piece.parent = null;
    }

    public void render(float textureWidth, float textureHeight) {
        if (!this.visible) {
            return;
        }
        GL11.glPushMatrix();
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.renderPrimitives(textureWidth, textureHeight);
        for (ModelPiece child : this.children) {
            child.render(textureWidth, textureHeight);
        }
        GL11.glPopMatrix();
    }

    public void renderForEditor(ModelPiece piece, Primitive prim, List<ModelPiece> highlightedPieces, float tw, float th) {
        boolean colored;
        GL11.glPushMatrix();
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        boolean selected = piece == this;
        boolean bl = colored = selected || highlightedPieces.contains(this);
        if (selected) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)2832);
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPointSize((float)5.0f);
            GL11.glBegin((int)0);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glEnd();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
        }
        if (colored) {
            GL11.glColor4f((float)0.75f, (float)0.5f, (float)0.5f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Primitive primitive : this.primitives) {
            if (primitive == prim) {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glBegin((int)0);
                GL11.glVertex3f((float)prim.x, (float)prim.y, (float)prim.z);
                GL11.glEnd();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)3553);
                GL11.glColor4f((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else if (colored) {
                GL11.glColor4f((float)0.75f, (float)0.5f, (float)0.5f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            primitive.render(tw, th);
        }
        for (ModelPiece child : this.children) {
            child.renderForEditor(piece, prim, highlightedPieces, tw, th);
        }
        GL11.glPopMatrix();
    }

    public void renderForSelection(float tw, float th, ModelBaseAW model) {
        GL11.glPushMatrix();
        if (this.x != 0.0f || this.y != 0.0f || this.z != 0.0f) {
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }
        if (this.rx != 0.0f) {
            GL11.glRotatef((float)this.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.ry != 0.0f) {
            GL11.glRotatef((float)this.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rz != 0.0f) {
            GL11.glRotatef((float)this.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        for (Primitive primitive : this.primitives) {
            byte r = (byte)(model.iterationNum >> 14 & 0x7F);
            byte g = (byte)(model.iterationNum >> 7 & 0x7F);
            byte b = (byte)(model.iterationNum >> 0 & 0x7F);
            GL11.glColor3b((byte)r, (byte)g, (byte)b);
            GL11.glPushMatrix();
            primitive.render(tw, th);
            GL11.glPopMatrix();
            ++model.iterationNum;
        }
        for (ModelPiece child : this.children) {
            child.renderForSelection(tw, th, model);
        }
        GL11.glPopMatrix();
    }

    public void getPieces(List<ModelPiece> input) {
        input.add(this);
        for (ModelPiece piece : this.children) {
            piece.getPieces(input);
        }
    }

    public List<Primitive> getPrimitives() {
        return this.primitives;
    }

    public void addPieceLines(ArrayList<String> lines) {
        StringBuilder b = new StringBuilder("part=");
        b.append(this.pieceName).append(",");
        b.append(this.parent == null ? "null" : this.parent.getName()).append(",");
        b.append(this.x).append(",").append(this.y).append(",").append(this.z).append(",").append(this.rx).append(",").append(this.ry).append(",").append(this.rz);
        lines.add(b.toString());
        for (Primitive primitive : this.primitives) {
            primitive.addPrimitiveLines(lines);
        }
        for (ModelPiece modelPiece : this.children) {
            modelPiece.addPieceLines(lines);
        }
    }

    public Primitive getPickedPrimitive(int num, ModelBaseAW model) {
        for (Primitive p : this.primitives) {
            if (model.iterationNum == num) {
                return p;
            }
            ++model.iterationNum;
        }
        for (ModelPiece mp : this.children) {
            Primitive p = mp.getPickedPrimitive(num, model);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    protected void renderPrimitives(float tw, float th) {
        if (!this.compiled) {
            this.compiled = true;
            if (this.displayList < 0) {
                this.displayList = GL11.glGenLists((int)1);
            }
            GL11.glNewList((int)this.displayList, (int)4864);
            for (Primitive p : this.primitives) {
                p.render(tw, th);
            }
            GL11.glEndList();
            GL11.glCallList((int)this.displayList);
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    protected void finalize() throws Throwable {
        if (this.displayList >= 0) {
            GL11.glDeleteLists((int)this.displayList, (int)1);
        }
        super.finalize();
    }
}

