/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import org.lwjgl.opengl.GL11;

public class CompositeItemSlots
extends CompositeScrolled {
    protected static RenderItem itemRender = new RenderItem();
    private List<ItemSlot> itemSlots = new ArrayList<ItemSlot>();
    ITooltipRenderer render;

    public CompositeItemSlots(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height, ITooltipRenderer render) {
        super(gui, topLeftX, topLeftY, width, height);
        this.render = render;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTextureLocation);
        RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.renderX, this.renderY, this.width, this.height);
        this.setViewport();
        for (GuiElement element : this.elements) {
            if (element.renderY > this.renderY + this.height || element.renderY + element.height < this.renderY || element.renderX > this.renderX + this.width || element.renderX + element.width < this.renderX) continue;
            if (element instanceof ItemSlot) {
                this.itemSlots.add((ItemSlot)element);
                continue;
            }
            element.render(mouseX, mouseY, partialTick);
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(widgetTexture1);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ItemSlot slot : this.itemSlots) {
            this.renderSlotBackground(slot);
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        RenderHelper.func_74520_c();
        CompositeItemSlots.itemRender.field_77023_b = 10.0f;
        for (ItemSlot slot : this.itemSlots) {
            this.renderItemStack(slot, mouseX, mouseY);
        }
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        for (ItemSlot slot : this.itemSlots) {
            this.renderOverlay(slot, mouseX, mouseY);
        }
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.55f);
        for (ItemSlot slot : this.itemSlots) {
            this.renderSlotHighlight(slot, mouseX, mouseY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.itemSlots.clear();
        this.popViewport();
        GL11.glEnable((int)3553);
        this.scrollbar.render(mouseX, mouseY, partialTick);
    }

    private void renderSlotBackground(ItemSlot slot) {
        if (slot.visible && slot.renderSlotBackground) {
            RenderTools.renderQuarteredTexture(256, 256, 152, 120, 18, 18, slot.renderX, slot.renderY, slot.width, slot.height);
        }
    }

    private void renderSlotHighlight(ItemSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack == null || stack.func_77973_b() == null || !slot.visible) {
            return;
        }
        if (slot.highlightOnMouseOver && slot.isMouseOverElement(mouseX, mouseY)) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBegin((int)7);
            GL11.glVertex2f((float)slot.renderX, (float)slot.renderY);
            GL11.glVertex2f((float)slot.renderX, (float)(slot.renderY + slot.height));
            GL11.glVertex2f((float)(slot.renderX + slot.width), (float)(slot.renderY + slot.height));
            GL11.glVertex2d((double)(slot.renderX + slot.width), (double)slot.renderY);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            if (slot.renderTooltip && slot.getStack() != null && this.render != null) {
                if (slot.tooltip != null) {
                    this.render.handleElementTooltipRender(slot.tooltip);
                } else {
                    this.render.handleItemStackTooltipRender(slot.getStack());
                }
            }
        }
    }

    private void renderOverlay(ItemSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack == null || stack.func_77973_b() == null || !slot.visible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = mc.field_71466_p;
        }
        if (slot.renderItemQuantity && slot.getStack().field_77994_a > 1) {
            itemRender.func_94148_a(font, mc.func_110434_K(), stack, slot.renderX + 1, slot.renderY + 1, "");
            slot.renderStackSize(slot.renderX + 1, slot.renderY + 1, stack.field_77994_a, font);
        }
    }

    private void renderItemStack(ItemSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack == null || stack.func_77973_b() == null || !slot.visible) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = mc.field_71466_p;
        }
        itemRender.func_82406_b(font, mc.func_110434_K(), stack, slot.renderX + 1, slot.renderY + 1);
    }
}

