/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.api.IAncientWarfarePlantable;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBlockBased;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public abstract class TileWorksiteUserBlocks
extends TileWorksiteBlockBased {
    protected static final int TOP_LENGTH = 27;
    protected static final int FRONT_LENGTH = 3;
    protected static final int BOTTOM_LENGTH = 3;
    private static final int SIZE = 16;
    private byte[] targetMap = new byte[256];
    private boolean shouldCountResources = true;

    public TileWorksiteUserBlocks() {
        this.inventory = new SlotListener(33);
    }

    @Override
    public final boolean userAdjustableBlocks() {
        return true;
    }

    protected boolean isTarget(BlockPosition p) {
        return this.isTarget(p.x, p.z);
    }

    protected boolean isTarget(int x1, int y1) {
        int z = (y1 - this.getWorkBoundsMin().z) * 16 + x1 - this.getWorkBoundsMin().x;
        return z >= 0 && z < this.targetMap.length && this.targetMap[z] == 1;
    }

    protected boolean isBonemeal(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15;
    }

    protected boolean isFarmable(Block block) {
        try {
            return this.isFarmable(block, 0, 0, 0);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isFarmable(Block block, int x, int y, int z) {
        return block instanceof IPlantable;
    }

    protected boolean canReplace(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_145850_b, x, y, z);
    }

    protected boolean tryPlace(ItemStack stack, int x, int y, int z, ForgeDirection face) {
        ForgeDirection direction = face.getOpposite();
        if (stack.func_77973_b() instanceof IAncientWarfarePlantable) {
            return ((IAncientWarfarePlantable)stack.func_77973_b()).tryPlant(this.field_145850_b, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, stack.func_77946_l());
        }
        EntityPlayer owner = this.getOwnerAsPlayer();
        if (owner.func_85032_ar()) {
            owner.field_71071_by.func_70299_a(owner.field_71071_by.field_70461_c, stack);
        }
        return stack.func_77943_a(owner, this.field_145850_b, x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, face.ordinal(), 0.25f, 0.25f, 0.25f);
    }

    protected final void pickupItems() {
        List<EntityItem> items = this.getEntitiesWithinBounds(EntityItem.class);
        if (items.isEmpty()) {
            return;
        }
        int[] indices = this.getIndicesForPickup();
        for (EntityItem item : items) {
            ItemStack stack;
            if (!item.func_70089_S() || (stack = item.func_92059_d()) == null) continue;
            if ((stack = InventoryTools.mergeItemStack((IInventory)this.inventory, stack, indices)) != null) {
                item.func_92058_a(stack);
                continue;
            }
            item.func_70106_y();
        }
    }

    protected int[] getIndicesForPickup() {
        return this.inventory.getRawIndicesCombined();
    }

    @Override
    protected void validateCollection(Collection<BlockPosition> blocks) {
        BlockPosition pos;
        if (!this.hasWorkBounds()) {
            blocks.clear();
            return;
        }
        Iterator<BlockPosition> it = blocks.iterator();
        while (it.hasNext() && (pos = it.next()) != null) {
            if (this.isInBounds(pos) && this.isTarget(pos)) continue;
            it.remove();
        }
    }

    @Override
    protected void fillBlocksToProcess(Collection<BlockPosition> targets) {
        BlockPosition min = this.getWorkBoundsMin();
        BlockPosition max = this.getWorkBoundsMax();
        for (int x = min.x; x < max.x + 1; ++x) {
            for (int z = min.z; z < max.z + 1; ++z) {
                if (!this.isTarget(x, z)) continue;
                targets.add(new BlockPosition(x, min.y, z));
            }
        }
    }

    public void onTargetsAdjusted() {
        this.onBoundsAdjusted();
    }

    @Override
    protected void onBoundsSet() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.targetMap[z * 16 + x] = 1;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74773_a("targetMap", this.targetMap);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("targetMap")) {
            this.targetMap = tag.func_74770_j("targetMap");
        }
    }

    public byte[] getTargetMap() {
        return this.targetMap;
    }

    public void setTargetBlocks(byte[] targets) {
        boolean change = !Objects.deepEquals(this.targetMap, targets);
        this.targetMap = targets;
        if (change) {
            this.onTargetsAdjusted();
            this.func_70296_d();
        }
    }

    @Override
    protected void updateBlockWorksite() {
        this.field_145850_b.field_72984_F.func_76320_a("Items Pickup");
        if (this.field_145850_b.func_72820_D() % 20L == 0L) {
            this.pickupItems();
        }
        this.field_145850_b.field_72984_F.func_76318_c("Count Resources");
        if (this.shouldCountResources) {
            this.countResources();
            this.shouldCountResources = false;
        }
        this.field_145850_b.field_72984_F.func_76319_b();
    }

    protected abstract void countResources();

    protected final class SlotListener
    extends BlockRotationHandler.InventorySided {
        public SlotListener(int inventorySize) {
            super(TileWorksiteUserBlocks.this, BlockRotationHandler.RotationType.FOUR_WAY, inventorySize);
        }

        @Override
        public ItemStack func_70298_a(int var1, int var2) {
            ItemStack result = super.func_70298_a(var1, var2);
            if (result != null && this.getFilterForSlot(var1) != null) {
                TileWorksiteUserBlocks.this.shouldCountResources = true;
            }
            return result;
        }

        @Override
        public ItemStack func_70304_b(int var1) {
            ItemStack result = super.func_70304_b(var1);
            if (result != null && this.getFilterForSlot(var1) != null) {
                TileWorksiteUserBlocks.this.shouldCountResources = true;
            }
            return result;
        }

        @Override
        public void func_70299_a(int var1, ItemStack var2) {
            super.func_70299_a(var1, var2);
            if (this.getFilterForSlot(var1) != null) {
                TileWorksiteUserBlocks.this.shouldCountResources = true;
            }
        }
    }
}

