/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;

public class WarehouseStorageMap {
    Set<IWarehouseStorageTile> unfilteredStorage = new HashSet<IWarehouseStorageTile>();
    Map<ItemQuantityMap.ItemHashEntry, Set<IWarehouseStorageTile>> storageMap = new HashMap<ItemQuantityMap.ItemHashEntry, Set<IWarehouseStorageTile>>();

    public final void addStorageTile(IWarehouseStorageTile tile) {
        this.addTileFilters(tile, tile.getFilters());
    }

    public final void removeStorageTile(IWarehouseStorageTile tile) {
        this.removeTileFilters(tile, tile.getFilters());
    }

    public final void updateTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> oldFilters, List<WarehouseStorageFilter> newFilters) {
        this.removeTileFilters(tile, oldFilters);
        this.addTileFilters(tile, newFilters);
    }

    public final Set<IWarehouseStorageTile> getFilterSetFor(ItemStack filter) {
        return this.getOrCreateStorageSet(new ItemQuantityMap.ItemHashEntry(filter));
    }

    public final Set<IWarehouseStorageTile> getUnFilteredSet() {
        return this.unfilteredStorage;
    }

    public final void getDestinations(ItemStack filter, List<IWarehouseStorageTile> out) {
        ItemQuantityMap.ItemHashEntry key = new ItemQuantityMap.ItemHashEntry(filter);
        Set<IWarehouseStorageTile> set = this.getOrCreateStorageSet(key);
        out.addAll(set);
        out.addAll(this.unfilteredStorage);
    }

    private Set<IWarehouseStorageTile> getOrCreateStorageSet(ItemQuantityMap.ItemHashEntry key) {
        Set<IWarehouseStorageTile> set = this.storageMap.get(key);
        if (set == null) {
            set = new HashSet<IWarehouseStorageTile>();
            this.storageMap.put(key, set);
        }
        return set;
    }

    private void removeTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> filters) {
        if (filters.isEmpty()) {
            this.unfilteredStorage.remove(tile);
        } else {
            for (WarehouseStorageFilter filter : filters) {
                if (filter.hashKey == null) continue;
                this.getOrCreateStorageSet(filter.hashKey).remove(tile);
            }
        }
    }

    private void addTileFilters(IWarehouseStorageTile tile, List<WarehouseStorageFilter> filters) {
        if (filters.isEmpty()) {
            this.unfilteredStorage.add(tile);
        } else {
            for (WarehouseStorageFilter filter : filters) {
                if (filter.hashKey == null) continue;
                this.getOrCreateStorageSet(filter.hashKey).add(tile);
            }
        }
    }
}

