/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.shadowmage.ancientwarfare.automation.container.ContainerMailbox;
import net.shadowmage.ancientwarfare.automation.gui.GuiMailboxInventory;
import net.shadowmage.ancientwarfare.automation.tile.TileMailbox;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.Direction;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import org.lwjgl.input.Mouse;

public class GuiMailboxInventorySideSetup
extends GuiContainerBase<ContainerMailbox> {
    private final GuiMailboxInventory parent;

    public GuiMailboxInventorySideSetup(GuiMailboxInventory parent) {
        super((ContainerBase)((Object)parent.getContainer()), 240, 108);
        this.parent = parent;
    }

    @Override
    public void initElements() {
    }

    @Override
    public void setupElements() {
        this.clearElements();
        Label label = new Label(8, 6, "guistrings.automation.block_side");
        this.addGuiElement(label);
        label = new Label(74, 6, "guistrings.automation.direction");
        this.addGuiElement(label);
        label = new Label(128, 6, "guistrings.automation.inventory_accessed");
        this.addGuiElement(label);
        int height = 18;
        for (BlockRotationHandler.RelativeSide side : BlockRotationHandler.RotationType.FOUR_WAY.getValidSides()) {
            label = new Label(8, height, side.getTranslationKey());
            this.addGuiElement(label);
            int dir = BlockRotationHandler.RelativeSide.getMCSideToAccess(BlockRotationHandler.RotationType.FOUR_WAY, ((TileMailbox)((ContainerMailbox)((Object)this.getContainer())).tileEntity).func_145832_p(), side);
            label = new Label(74, height, Direction.getDirectionFor(dir).getTranslationKey());
            this.addGuiElement(label);
            BlockRotationHandler.RelativeSide accessed = ((ContainerMailbox)((Object)this.getContainer())).sideMap.get((Object)side);
            SideButton sideButton = new SideButton(128, height, side, accessed);
            this.addGuiElement(sideButton);
            height += 14;
        }
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerMailbox)((Object)this.getContainer())).addSlots();
        int x = Mouse.getX();
        int y = Mouse.getY();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        Mouse.setCursorPosition((int)x, (int)y);
        return false;
    }

    private class SideButton
    extends Button {
        final BlockRotationHandler.RelativeSide side;
        BlockRotationHandler.RelativeSide selection;

        public SideButton(int topLeftX, int topLeftY, BlockRotationHandler.RelativeSide side, BlockRotationHandler.RelativeSide selection) {
            super(topLeftX, topLeftY, 55, 12, selection.getTranslationKey());
            if (side == null) {
                throw new IllegalArgumentException("access side may not be null..");
            }
            this.side = side;
            this.selection = selection;
        }

        @Override
        protected void onPressed() {
            int ordinal = this.selection.ordinal();
            EnumSet<BlockRotationHandler.RelativeSide> validSides = ((TileMailbox)((ContainerMailbox)((Object)GuiMailboxInventorySideSetup.this.getContainer())).tileEntity).inventory.getValidSides();
            for (int i = 0; i < BlockRotationHandler.RelativeSide.values().length; ++i) {
                BlockRotationHandler.RelativeSide next;
                if (++ordinal >= BlockRotationHandler.RelativeSide.values().length) {
                    ordinal = 0;
                }
                if (!validSides.contains((Object)(next = BlockRotationHandler.RelativeSide.values()[ordinal]))) continue;
                this.selection = next;
                break;
            }
            ((ContainerMailbox)((Object)GuiMailboxInventorySideSetup.this.getContainer())).sideMap.put(this.side, this.selection);
            this.setText(this.selection.getTranslationKey());
            ((ContainerMailbox)((Object)GuiMailboxInventorySideSetup.this.getContainer())).sendSlotChange(this.side, this.selection);
        }
    }
}

