/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.automation.gamedata.MailboxData;
import net.shadowmage.ancientwarfare.automation.tile.TileMailbox;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.StringTools;

public class ContainerMailbox
extends ContainerTileBase<TileMailbox> {
    public int guiHeight;
    public HashMap<BlockRotationHandler.RelativeSide, BlockRotationHandler.RelativeSide> sideMap = new HashMap();
    public String targetName;
    public String mailboxName;
    public boolean autoExport;
    public boolean privateBox;
    public List<String> publicBoxNames = new ArrayList<String>();
    public List<String> privateBoxNames = new ArrayList<String>();

    public ContainerMailbox(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        int y1;
        int x1;
        int i;
        BlockRotationHandler.InventorySided inventory = ((TileMailbox)this.tileEntity).inventory;
        for (BlockRotationHandler.RelativeSide rSide : inventory.rType.getValidSides()) {
            this.sideMap.put(rSide, inventory.getRemappedSide(rSide));
        }
        for (i = 0; i < 18; ++i) {
            x1 = i % 9;
            y1 = i / 9;
            int xPos = x1 * 18 + 8;
            int yPos = y1 * 18 + 8 + 12;
            this.func_75146_a(new Slot((IInventory)inventory, i, xPos, yPos));
        }
        for (i = 0; i < 18; ++i) {
            x1 = i % 9;
            y1 = i / 9;
            int xPos = x1 * 18 + 8;
            int yPos = y1 * 18 + 8 + 12 + 36 + 12;
            this.func_75146_a(new Slot((IInventory)inventory, i + 18, xPos, yPos));
        }
        y1 = 104;
        this.guiHeight = this.addPlayerSlots(y1 + 12) + 8 + 24;
        if (!player.field_70170_p.field_72995_K) {
            MailboxData data = AWGameData.INSTANCE.getData(player.field_70170_p, MailboxData.class);
            this.publicBoxNames.addAll(data.getPublicBoxNames());
            this.privateBoxNames.addAll(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwnerName()));
            this.privateBox = ((TileMailbox)this.tileEntity).isPrivateBox();
            this.autoExport = ((TileMailbox)this.tileEntity).isAutoExport();
            this.mailboxName = ((TileMailbox)this.tileEntity).getMailboxName();
            this.targetName = ((TileMailbox)this.tileEntity).getTargetName();
        }
    }

    @Override
    public void sendInitData() {
        this.sendAccessMap();
        NBTTagCompound tag = new NBTTagCompound();
        if (this.mailboxName != null) {
            tag.func_74778_a("mailboxName", this.mailboxName);
        }
        if (this.targetName != null) {
            tag.func_74778_a("targetName", this.targetName);
        }
        tag.func_74757_a("privateBox", this.privateBox);
        tag.func_74757_a("autoExport", this.autoExport);
        NBTTagList nameList = new NBTTagList();
        for (String boxName : this.publicBoxNames) {
            nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
        }
        tag.func_74782_a("publicBoxNames", (NBTBase)nameList);
        nameList = new NBTTagList();
        for (String boxName : this.privateBoxNames) {
            nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
        }
        tag.func_74782_a("privateBoxNames", (NBTBase)nameList);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        int i;
        NBTTagList nameList;
        this.handleAccessMapTag(tag);
        if (tag.func_74764_b("autoExport")) {
            this.autoExport = tag.func_74767_n("autoExport");
            ((TileMailbox)this.tileEntity).setAutoExport(this.autoExport);
        }
        if (tag.func_74764_b("privateBox")) {
            this.privateBox = tag.func_74767_n("privateBox");
            ((TileMailbox)this.tileEntity).setPrivateBox(this.privateBox);
        }
        if (tag.func_74764_b("clearMailbox")) {
            this.mailboxName = null;
            ((TileMailbox)this.tileEntity).setMailboxName(null);
        } else if (tag.func_74764_b("mailboxName")) {
            this.mailboxName = tag.func_74779_i("mailboxName");
            ((TileMailbox)this.tileEntity).setMailboxName(this.mailboxName);
        }
        if (tag.func_74764_b("clearTarget")) {
            this.targetName = null;
            ((TileMailbox)this.tileEntity).setTargetName(null);
        } else if (tag.func_74764_b("targetName")) {
            this.targetName = tag.func_74779_i("targetName");
            ((TileMailbox)this.tileEntity).setTargetName(this.targetName);
        }
        if (tag.func_74764_b("publicBoxNames")) {
            this.publicBoxNames.clear();
            nameList = tag.func_150295_c("publicBoxNames", 8);
            for (i = 0; i < nameList.func_74745_c(); ++i) {
                this.publicBoxNames.add(nameList.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("privateBoxNames")) {
            this.privateBoxNames.clear();
            nameList = tag.func_150295_c("privateBoxNames", 8);
            for (i = 0; i < nameList.func_74745_c(); ++i) {
                this.privateBoxNames.add(nameList.func_150307_f(i));
            }
        }
        if (tag.func_74764_b("addMailbox") || tag.func_74764_b("deleteMailbox")) {
            MailboxData data = AWGameData.INSTANCE.getData(this.player.field_70170_p, MailboxData.class);
            String name = tag.func_74779_i("addMailbox");
            if (!name.isEmpty()) {
                data.addMailbox(((TileMailbox)this.tileEntity).isPrivateBox() ? ((TileMailbox)this.tileEntity).getOwnerName() : null, name);
            }
            if (!(name = tag.func_74779_i("deleteMailbox")).isEmpty()) {
                data.deleteMailbox(((TileMailbox)this.tileEntity).isPrivateBox() ? ((TileMailbox)this.tileEntity).getOwnerName() : null, name);
            }
        }
        this.refreshGui();
    }

    private void sendAccessMap() {
        int l = this.sideMap.size();
        int[] rMap = new int[l];
        int[] iMap = new int[l];
        int index = 0;
        for (BlockRotationHandler.RelativeSide rSide : this.sideMap.keySet()) {
            rMap[index] = rSide.ordinal();
            iMap[index] = this.sideMap.get((Object)rSide).ordinal();
            ++index;
        }
        NBTTagCompound accessTag = new NBTTagCompound();
        accessTag.func_74783_a("rMap", rMap);
        accessTag.func_74783_a("iMap", iMap);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("accessMap", (NBTBase)accessTag);
        this.sendDataToClient(tag);
    }

    private void handleAccessMapTag(NBTTagCompound tag) {
        if (tag.func_74764_b("accessMap")) {
            NBTTagCompound accessTag = tag.func_74775_l("accessMap");
            int[] rMap = accessTag.func_74759_k("rMap");
            int[] rMap2 = accessTag.func_74759_k("iMap");
            for (int i = 0; i < rMap.length && i < rMap2.length; ++i) {
                BlockRotationHandler.RelativeSide rSide = BlockRotationHandler.RelativeSide.values()[rMap[i]];
                BlockRotationHandler.RelativeSide iSide = BlockRotationHandler.RelativeSide.values()[rMap2[i]];
                this.sideMap.put(rSide, iSide);
            }
        }
        if (tag.func_74764_b("accessChange")) {
            NBTTagCompound slotTag = tag.func_74775_l("accessChange");
            BlockRotationHandler.RelativeSide base = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("baseSide")];
            BlockRotationHandler.RelativeSide access = BlockRotationHandler.RelativeSide.values()[slotTag.func_74762_e("accessSide")];
            this.sideMap.put(base, access);
            if (!this.player.field_70170_p.field_72995_K) {
                ((TileMailbox)this.tileEntity).inventory.remapSideAccess(base, access);
            }
        }
    }

    private void synchAccessMap() {
        for (BlockRotationHandler.RelativeSide rSide : ((TileMailbox)this.tileEntity).inventory.rType.getValidSides()) {
            BlockRotationHandler.RelativeSide rSide3;
            BlockRotationHandler.RelativeSide rSide2 = ((TileMailbox)this.tileEntity).inventory.getRemappedSide(rSide);
            if (rSide2 == (rSide3 = this.sideMap.get((Object)rSide))) continue;
            this.sideMap.put(rSide, rSide2);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a("baseSide", rSide.ordinal());
            slotTag.func_74768_a("accessSide", rSide2.ordinal());
            tag.func_74782_a("accessChange", (NBTBase)slotTag);
            this.sendDataToClient(tag);
        }
    }

    public void sendSlotChange(BlockRotationHandler.RelativeSide base, BlockRotationHandler.RelativeSide access) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound slotTag = new NBTTagCompound();
        slotTag.func_74768_a("baseSide", base.ordinal());
        slotTag.func_74768_a("accessSide", access.ordinal());
        tag.func_74782_a("accessChange", (NBTBase)slotTag);
        this.sendDataToServer(tag);
    }

    public void func_75142_b() {
        NBTTagList nameList;
        MailboxData data;
        super.func_75142_b();
        this.synchAccessMap();
        NBTTagCompound tag = null;
        String name = ((TileMailbox)this.tileEntity).getMailboxName();
        if (!StringTools.doStringsMatch(name, this.mailboxName)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.mailboxName = ((TileMailbox)this.tileEntity).getMailboxName();
            if (this.mailboxName == null) {
                tag.func_74757_a("clearMailbox", true);
            } else {
                tag.func_74778_a("mailboxName", this.mailboxName);
            }
        }
        if (!StringTools.doStringsMatch(name = ((TileMailbox)this.tileEntity).getTargetName(), this.targetName)) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.targetName = ((TileMailbox)this.tileEntity).getTargetName();
            if (this.targetName == null) {
                tag.func_74757_a("clearTarget", true);
            } else {
                tag.func_74778_a("targetName", this.targetName);
            }
        }
        if (this.autoExport != ((TileMailbox)this.tileEntity).isAutoExport()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.autoExport = ((TileMailbox)this.tileEntity).isAutoExport();
            tag.func_74757_a("autoExport", this.autoExport);
        }
        if (this.privateBox != ((TileMailbox)this.tileEntity).isPrivateBox()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.privateBox = ((TileMailbox)this.tileEntity).isPrivateBox();
            tag.func_74757_a("privateBox", this.privateBox);
        }
        if (!this.publicBoxNames.equals((data = AWGameData.INSTANCE.getData(this.player.field_70170_p, MailboxData.class)).getPublicBoxNames())) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.publicBoxNames.clear();
            this.publicBoxNames.addAll(data.getPublicBoxNames());
            nameList = new NBTTagList();
            for (String boxName : this.publicBoxNames) {
                nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
            }
            tag.func_74782_a("publicBoxNames", (NBTBase)nameList);
        }
        if (!this.privateBoxNames.equals(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwnerName()))) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.privateBoxNames.clear();
            this.privateBoxNames.addAll(data.getPrivateBoxNames(((TileMailbox)this.tileEntity).getOwnerName()));
            nameList = new NBTTagList();
            for (String boxName : this.privateBoxNames) {
                nameList.func_74742_a((NBTBase)new NBTTagString(boxName));
            }
            tag.func_74782_a("privateBoxNames", (NBTBase)nameList);
        }
        if (tag != null) {
            this.sendDataToClient(tag);
        }
    }

    public void handleNameAdd(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("addMailbox", name);
        this.sendDataToServer(tag);
    }

    public void handleNameDelete(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("deleteMailbox", name);
        this.sendDataToServer(tag);
    }

    public void handleNameSelection(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        if (name == null) {
            tag.func_74757_a("clearMailbox", true);
        } else {
            tag.func_74778_a("mailboxName", name);
        }
        this.mailboxName = name;
        this.sendDataToServer(tag);
    }

    public void handleTargetSelection(String name) {
        NBTTagCompound tag = new NBTTagCompound();
        if (name == null) {
            tag.func_74757_a("clearTarget", true);
        } else {
            tag.func_74778_a("targetName", name);
        }
        this.targetName = name;
        this.sendDataToServer(tag);
    }

    public void handlePrivateBoxToggle(boolean newVal) {
        this.targetName = null;
        this.mailboxName = null;
        this.privateBox = newVal;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("privateBox", this.privateBox);
        this.sendDataToServer(tag);
    }

    public void handleAutoExportToggle(boolean newVal) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("autoExport", newVal);
        this.sendDataToServer(tag);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = null;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (slotStack.field_77994_a == 0) {
                theSlot.func_75215_d(null);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.field_77994_a == slotStackCopy.field_77994_a) {
                return null;
            }
            theSlot.func_82870_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }
}

