/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.config;

import net.minecraftforge.common.config.Property;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;

public class AWAutomationStatics
extends ModConfiguration {
    public static int conduitRenderID = -1;
    public static int sterlingEngineRenderID = -1;
    public static int fishFarmRescanTicks = 200;
    public static int animalFarmRescanTicks = 200;
    public static int mailboxTimePerBlock = 20;
    public static int mailboxTimeForDimension = 1200;
    public static int energyMinNetworkUpdateFrequency = 5;
    public static boolean enable_energy_network_updates = true;
    public static boolean enable_energy_client_updates = true;
    public static double low_efficiency_factor = 0.9999;
    public static double med_efficiency_factor = 0.99995;
    public static double high_efficiency_factor = 0.99999;
    public static double low_transfer_max = 32.0;
    public static double med_transfer_max = 192.0;
    public static double high_transfer_max = 1024.0;
    public static double low_conduit_energy_max = 32.0;
    public static double med_conduit_energy_max = 192.0;
    public static double high_conduit_energy_max = 1024.0;
    public static double low_storage_energy_max = 9600.0;
    public static double med_storage_energy_max = 14400.0;
    public static double high_storage_energy_max = 24000.0;
    public static double sterling_generator_output = 1.0;
    public static double waterwheel_generator_output = 1.0;
    public static double hand_cranked_generator_output = 1.0;
    public static double windmill_per_size_output = 1.0;
    public static final float rpmToRpt = 0.3f;
    public static final float low_quality_rpm = 100.0f;
    public static final float low_rpt = 30.000002f;
    public static double rfToTorque = 0.1;
    public static final double mjToTorque = 1.0;
    public static double torqueToRf = 10.0;
    public static final double torqueToMj = 1.0;
    public static Property renderWorkBounds;

    public AWAutomationStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment("01_shared_settings", "General Options\nAffect both client and server. These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment("02_server_settings", "Server Options\nAffect only server-side operations. Will need to be set for dedicated servers, and single\nplayer (or LAN worlds). Clients playing on remote servers can ignore these settings.");
        this.config.addCustomCategoryComment("03_client_settings", "Client Options\nAffect only client-side operations. Many of these options can be set from the in-game Options GUI.\nServer admins can ignore these settings.");
    }

    @Override
    public void initializeValues() {
        double temp = this.config.get("01_shared_settings", "rf_energy_conversion_factor", torqueToRf, "How much rf energy units for one unit of torque based energy.\nDefault= " + torqueToRf + "\n" + "Zero or negative values stop rf energy from being used in automated blocks.").getDouble();
        if (temp <= 0.0) {
            torqueToRf = 0.0;
            rfToTorque = 0.0;
        } else {
            torqueToRf = temp;
            rfToTorque = 1.0 / temp;
        }
        energyMinNetworkUpdateFrequency = this.config.get("01_shared_settings", "energy_network_update_frequency", energyMinNetworkUpdateFrequency, "Alter the frequency at which network updates are sent to clients.\nDefault= " + energyMinNetworkUpdateFrequency + "\n" + "Lower values send data more often. Higher values send less often. Zero or negative values send every tick.").getInt();
        enable_energy_network_updates = this.config.get("02_server_settings", "enable_server_energy_network", enable_energy_network_updates, "Enable/Disable Sending network updates for energy tiles.\nDefault = " + enable_energy_network_updates + "\n" + "Disabling may improve server network performance on congested/low-bandwith deployments.").getBoolean();
        mailboxTimePerBlock = this.config.get("02_server_settings", "mailbox_travel_time_per_block", mailboxTimePerBlock, "Ticks per block to be traveled for teleporting items.\nDefault= " + mailboxTimePerBlock + "Higher values increase travel time for items. Lower values reduce travel time.\n" + "Zero or negative values result in instant transfer.").getInt();
        mailboxTimeForDimension = this.config.get("02_server_settings", "mailbox_travel_time_per_dimension", mailboxTimeForDimension, "Ticks for dimensional travel for teleporting items.\nDefault= " + mailboxTimeForDimension + "Higher values increase travel time for items. Lower values reduce travel time.\n" + "Zero or negative values result in instant transfer.").getInt();
        low_efficiency_factor = this.config.get("02_server_settings", "low_quality_tile_energy_drain", low_efficiency_factor, "Factor applied to base drain algorithm to determine energy loss for low-quality torque tiles.\nDefault = " + low_efficiency_factor + "Higher values result in more energy drain. Lower values result in less.\n" + "Negative values will result in a feedback loop of free/infinite power.").getDouble();
        med_efficiency_factor = this.config.get("02_server_settings", "med_quality_tile_energy_drain", med_efficiency_factor, "Factor applied to base drain algorithm to determine energy loss for medium-quality torque tiles.\nDefault = " + med_efficiency_factor + "Higher values result in more energy drain. Lower values result in less.\n" + "Negative values will result in a feedback loop of free/infinite power.").getDouble();
        high_efficiency_factor = this.config.get("02_server_settings", "high_quality_tile_energy_drain", high_efficiency_factor, "Factor applied to base drain algorithm to determine energy loss for high-quality torque tiles.\nDefault = " + high_efficiency_factor + "Higher values result in more energy drain. Lower values result in less.\n" + "Negative values will result in a feedback loop of free/infinite power.").getDouble();
        low_transfer_max = this.config.get("02_server_settings", "low_quality_tile_energy_transfer", low_transfer_max, "How much energy may be output per tick by low-quality torque tiles.\nDefault = " + low_transfer_max + "Higher values result in more thoroughput of energy network. Lower values result in less.\n" + "Negative values will cause energy transfer to cease functioning.").getDouble();
        med_transfer_max = this.config.get("02_server_settings", "med_quality_tile_energy_transfer", med_transfer_max, "How much energy may be output per tick by medium-quality torque tiles.\nDefault = " + med_transfer_max + "Higher values result in more thoroughput of energy network. Lower values result in less.\n" + "Negative values will cause energy transfer to cease functioning.").getDouble();
        high_transfer_max = this.config.get("02_server_settings", "high_quality_tile_energy_transfer", high_transfer_max, "How much energy may be output per tick by high-quality torque tiles.\nDefault = " + high_transfer_max + "Higher values result in more thoroughput of energy network. Lower values result in less.\n" + "Negative values will cause energy transfer to cease functioning.").getDouble();
        low_conduit_energy_max = this.config.get("02_server_settings", "low_quality_conduit_energy_max", low_conduit_energy_max, "How much energy may be stored in low-quality energy transport tiles.\nDefault = " + low_conduit_energy_max + "\n" + "Directly sets the amount of torque/MJ that a transport conduit may store internally.").getDouble();
        med_conduit_energy_max = this.config.get("02_server_settings", "med_quality_conduit_energy_max", med_conduit_energy_max, "How much energy may be stored in medium-quality energy transport tiles.\nDefault = " + med_conduit_energy_max + "\n" + "Directly sets the amount of torque/MJ that a transport conduit may store internally.").getDouble();
        high_conduit_energy_max = this.config.get("02_server_settings", "high_quality_conduit_energy_max", high_conduit_energy_max, "How much energy may be stored in high-quality energy transport tiles.\nDefault = " + high_conduit_energy_max + "\n" + "Directly sets the amount of torque/MJ that a transport conduit may store internally.").getDouble();
        low_storage_energy_max = this.config.get("02_server_settings", "low_quality_storage_energy_max", low_storage_energy_max, "How much energy may be stored in low-quality energy storage tiles.\nDefault = " + low_storage_energy_max + "\n" + "Directly sets the amount of torque/MJ that a storage tile may store internally.").getDouble();
        med_storage_energy_max = this.config.get("02_server_settings", "med_quality_storage_energy_max", med_storage_energy_max, "How much energy may be stored in medium-quality energy storage tiles.\nDefault = " + med_storage_energy_max + "\n" + "Directly sets the amount of torque/MJ that a storage tile may store internally.").getDouble();
        high_storage_energy_max = this.config.get("02_server_settings", "high_quality_storage_energy_max", high_storage_energy_max, "How much energy may be stored in high-quality energy storage tiles.\nDefault = " + high_storage_energy_max + "\n" + "Directly sets the amount of torque/MJ that a storage tile may store internally.").getDouble();
        sterling_generator_output = this.config.get("02_server_settings", "sterling_generator_output_factor", sterling_generator_output, "Factor applied to energy output from sterling generator.\nDefault = " + sterling_generator_output + "Lower values reduce output, higher values increase output.\n" + "Zero or negative values will result in no energy output").getDouble();
        waterwheel_generator_output = this.config.get("02_server_settings", "waterwheel_generator_output_factor", waterwheel_generator_output, "Factor applied to energy output from waterwheel generator.\nDefault = " + waterwheel_generator_output + "Lower values reduce output, higher values increase output.\n" + "Zero or negative values will result in no energy output").getDouble();
        hand_cranked_generator_output = this.config.get("02_server_settings", "hand_cranked_generator_output_factor", hand_cranked_generator_output, "Factor applied to energy output from hand-cranked generator.\nDefault = " + hand_cranked_generator_output + "Lower values reduce output, higher values increase output.\n" + "Zero or negative values will result in no energy output").getDouble();
        windmill_per_size_output = this.config.get("02_server_settings", "windmill_per_size_output_factor", windmill_per_size_output, "Factor applied to energy output from windmill based on size.\nDefault = " + windmill_per_size_output + "Lower values reduce output, higher values increase output.\n" + "Zero or negative values will result in no energy output").getDouble();
        enable_energy_client_updates = this.config.getBoolean("enable_client_energy_animations", "03_client_settings", enable_energy_client_updates, "Enable client-side animation of power tiles. Disabling may improve rendering performance on low-end machines");
        renderWorkBounds = this.config.get("03_client_settings", "render_work_bounds", true);
    }
}

