/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.workbench;

import cofh.api.core.ICustomInventory;
import cofh.api.inventory.IInventoryRetainer;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.workbench.BlockWorkbench;
import cofh.thermalexpansion.gui.client.GuiWorkbench;
import cofh.thermalexpansion.gui.container.ContainerWorkbench;
import cofh.thermalexpansion.util.helpers.SchematicHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileWorkbench
extends TileInventory
implements ICustomInventory,
ISidedInventory,
IInventoryRetainer {
    public static int[] INVENTORY = new int[]{36, 18, 27, 33, 36};
    public static int[] SCHEMATICS = new int[]{12, 3, 6, 9, 12};
    private static int[][] SLOTS = new int[INVENTORY.length][];
    public static boolean enableSecurity;
    public byte type = 1;
    public int selectedSchematic = 0;
    public boolean[] missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
    public ItemStack[] craftingGrid = new ItemStack[9];
    public boolean updateClient = false;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileWorkbench.class, (String)"thermalexpansion.NewWorkbench");
        TileWorkbench.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Workbenches to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Workbench.All.Securable", enableSecurity, string);
    }

    public TileWorkbench() {
        this.inventory = new ItemStack[SCHEMATICS[1] + INVENTORY[1]];
    }

    public TileWorkbench(int n) {
        this.type = (byte)n;
        this.inventory = new ItemStack[SCHEMATICS[n] + INVENTORY[n]];
    }

    public String getName() {
        return "tile.thermalexpansion.workbench." + BlockWorkbench.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public int getCurrentSchematicSlot() {
        return this.selectedSchematic;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean createItem(boolean bl, ItemStack itemStack) {
        ItemStack[] itemStackArray = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean bl2 = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack2 = this.craftingGrid[i];
            String string = OreDictionaryArbiter.getOreName((ItemStack)itemStack2);
            if (itemStack2 == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                ItemStack itemStack3;
                if (itemStackArray[j] == null || !ItemHelper.craftingEquivalent((ItemStack)itemStackArray[j], (ItemStack)itemStack2, (String)string, (ItemStack)itemStack)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)itemStackArray[j], (int)1);
                --itemStackArray[j].field_77994_a;
                if (itemStackArray[j].func_77973_b().hasContainerItem(itemStackArray[j]) && (itemStack3 = itemStackArray[j].func_77973_b().getContainerItem(itemStackArray[j])) != null) {
                    if (itemStack3.func_77984_f() && itemStack3.func_77960_j() > itemStack3.func_77958_k()) {
                        itemStack3 = null;
                    }
                    if (!(itemStack3 == null || itemStackArray[j].func_77973_b().func_77630_h(itemStackArray[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])itemStackArray, (ItemStack)itemStack3, (int)3))) {
                        if (itemStackArray[j].field_77994_a <= 0) {
                            itemStackArray[j] = itemStack3;
                            if (itemStack3.field_77994_a <= 0) {
                                itemStackArray[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (itemStackArray[j].field_77994_a <= 0) {
                    itemStackArray[j] = null;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
            bl2 = false;
        }
        if (bl) {
            this.inventory = itemStackArray;
        }
        return true;
    }

    public boolean createItemClient(boolean bl, ItemStack itemStack) {
        ItemStack[] itemStackArray = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        boolean bl2 = false;
        boolean bl3 = true;
        this.missingItem = new boolean[]{false, false, false, false, false, false, false, false, false};
        for (int i = 0; i < 9; ++i) {
            ItemStack itemStack2 = this.craftingGrid[i];
            String string = OreDictionaryArbiter.getOreName((ItemStack)itemStack2);
            if (itemStack2 == null) continue;
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (itemStackArray[j] == null || !ItemHelper.craftingEquivalent((ItemStack)itemStackArray[j], (ItemStack)itemStack2, (String)string, (ItemStack)itemStack)) continue;
                this.craftingGrid[i] = ItemHelper.cloneStack((ItemStack)itemStackArray[j], (int)1);
                --itemStackArray[j].field_77994_a;
                if (itemStackArray[j].func_77973_b().hasContainerItem(itemStackArray[j])) {
                    ItemStack itemStack3 = itemStackArray[j].func_77973_b().getContainerItem(itemStackArray[j]);
                    if (itemStack3 == null || itemStack3.func_77984_f() && itemStack3.func_77960_j() > itemStack3.func_77958_k()) {
                        itemStack3 = null;
                    }
                    if (!(itemStack3 == null || itemStackArray[j].func_77973_b().func_77630_h(itemStackArray[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])itemStackArray, (ItemStack)itemStack3, (int)2))) {
                        if (itemStackArray[j].field_77994_a <= 0) {
                            itemStackArray[j] = itemStack3;
                            if (itemStack3.field_77994_a <= 0) {
                                itemStackArray[j].field_77994_a = 1;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                if (itemStackArray[j].field_77994_a <= 0) {
                    itemStackArray[j] = null;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                bl3 = false;
                this.missingItem[i] = true;
            }
            bl2 = false;
        }
        if (!bl3) {
            return false;
        }
        if (bl) {
            this.inventory = itemStackArray;
        }
        return true;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    public void clearCraftingGrid() {
        this.updateClient = true;
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid[i] = null;
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.CLEAR_GRID.ordinal()));
    }

    public void setCraftingGrid() {
        this.updateClient = true;
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid[i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
        }
        PacketHandler.sendToServer((PacketBase)PacketTileInfo.newPacket((TileEntity)this).addByte(PacketInfoID.SET_GRID.ordinal()));
    }

    public void setCurrentSchematicSlot(int n) {
        this.selectedSchematic = n;
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addByte(this.type);
        packetCoFHBase.addByte(this.selectedSchematic);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        return null;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.type = packetCoFHBase.getByte();
        this.selectedSchematic = packetCoFHBase.getByte();
    }

    @Override
    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        byte by = packetCoFHBase.getByte();
        if (by == PacketInfoID.CLEAR_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = null;
                if (entityPlayer.field_71070_bA == null) continue;
                entityPlayer.field_71070_bA.func_75130_a(null);
            }
        } else if (by == PacketInfoID.SET_GRID.ordinal()) {
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = SchematicHelper.getSchematicSlot(this.func_70301_a(this.getCurrentSchematicSlot()), i);
                if (entityPlayer.field_71070_bA == null) continue;
                entityPlayer.field_71070_bA.func_75130_a(null);
            }
        } else if (by == PacketInfoID.NEI_SUP.ordinal()) {
            byte by2;
            for (int i = 0; i < 9; ++i) {
                this.craftingGrid[i] = null;
            }
            while ((by2 = packetCoFHBase.getByte()) >= 0) {
                this.craftingGrid[by2] = packetCoFHBase.getItemStack();
            }
            Container container = entityPlayer.field_71070_bA;
            if (container != null) {
                ((ICrafting)entityPlayer).func_71110_a(container, container.func_75138_a());
                container.func_75130_a(null);
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiWorkbench(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerWorkbench(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.canPlayerAccess((EntityPlayer)iCrafting) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.func_74771_c("Type");
        this.selectedSchematic = nBTTagCompound.func_74771_c("Mode");
        this.readCraftingFromNBT(nBTTagCompound);
        this.inventory = new ItemStack[SCHEMATICS[this.type] + INVENTORY[this.type]];
        super.func_145839_a(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Type", this.type);
        nBTTagCompound.func_74774_a("Mode", (byte)this.selectedSchematic);
        this.writeCraftingToNBT(nBTTagCompound);
    }

    public void readCraftingFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Crafting", 10);
        this.craftingGrid = new ItemStack[9];
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.craftingGrid.length) continue;
            this.craftingGrid[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeCraftingToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.craftingGrid.length; ++i) {
            if (this.craftingGrid[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.craftingGrid[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Crafting", (NBTBase)nBTTagList);
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        this.updateClient = true;
        return super.func_70298_a(n, n2);
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this.updateClient = true;
        super.func_70299_a(n, itemStack);
    }

    public ItemStack[] getInventorySlots(int n) {
        return this.craftingGrid;
    }

    public int getSlotStackLimit(int n) {
        return 1;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    public int[] func_94128_d(int n) {
        return SLOTS[this.type];
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n >= SCHEMATICS[this.type];
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n >= SCHEMATICS[this.type];
    }

    static {
        for (int i = 0; i < SLOTS.length; ++i) {
            int[] nArray = new int[INVENTORY[i]];
            int n = SCHEMATICS[i];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = n++;
            }
            TileWorkbench.SLOTS[i] = nArray;
        }
        enableSecurity = true;
    }

    public static enum PacketInfoID {
        CLEAR_GRID,
        SET_GRID,
        NEI_SUP;

    }
}

