/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.energy.EnergyStorage;
import cofh.core.entity.CoFHFakePlayer;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiActivator;
import cofh.thermalexpansion.gui.container.device.ContainerActivator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class TileActivator
extends TileDeviceBase {
    static TileTEBase.EnergyConfig energyConfig;
    static int ACTIVATION_ENERGY;
    static int MAX_SLOT;
    public boolean leftClick = false;
    public byte tickSlot = 0;
    public boolean actsSneaking = false;
    public byte angle = 1;
    CoFHFakePlayer myFakePlayer;
    int slotTracker = 0;
    int[] tracker;
    static final IEntitySelector selectAttackable;

    public static void initialize() {
        int n = BlockDevice.Types.ACTIVATOR.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 4;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}, {0, 1, 2, 3, 4, 5, 6, 7, 8}};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, true, false, true};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false, true, true};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, false};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, false};
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 1, 4, 7};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        String string = "Device.Activator";
        int n2 = MathHelper.clamp((int)ThermalExpansion.config.get(string, "BasePower", 20), (int)0, (int)500);
        ThermalExpansion.config.set("Device.Activator", "BasePower", n2);
        energyConfig = new TileTEBase.EnergyConfig();
        energyConfig.setParamsPower(n2);
        String string2 = "This value sets how much energy the Activator uses when it actually does something. Set to 0 to disable it requiring energy.";
        n2 = MathHelper.clamp((int)ThermalExpansion.config.get(string, "ActivationEnergy", ACTIVATION_ENERGY, string2), (int)0, (int)500);
        ThermalExpansion.config.set("Device.Activator", "ActivationEnergy", n2);
        ACTIVATION_ENERGY = n2;
        GameRegistry.registerTileEntity(TileActivator.class, (String)"thermalexpansion.Activator");
    }

    public TileActivator() {
        super(BlockDevice.Types.ACTIVATOR);
        this.inventory = new ItemStack[10];
        this.energyStorage = new EnergyStorage(TileActivator.energyConfig.maxEnergy, TileActivator.energyConfig.maxPower * 3);
    }

    @Override
    public void cofh_validate() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.myFakePlayer = new CoFHFakePlayer((WorldServer)((TileEntity)this).field_145850_b);
        }
        super.cofh_validate();
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 2;
    }

    @Override
    public void onRedstoneUpdate() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.inWorld) {
            this.cofh_validate();
        }
        if (!this.redstoneControlOrDisable() && this.myFakePlayer.field_71074_e != null) {
            this.myFakePlayer.func_71034_by();
        } else {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
            Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
            if (block != null && block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, nArray[0], nArray[1], nArray[2])) {
                this.doDeploy();
            }
        }
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (!this.inWorld) {
            this.cofh_validate();
        }
        if (this.hasEnergy(ACTIVATION_ENERGY)) {
            if (!this.isActive) {
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            this.isActive = true;
            boolean bl = false;
            if (((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
                bl = this.doDeploy();
            } else if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1) {
                bl = true;
                int n = this.getNextStackIndex();
                this.myFakePlayer.field_71134_c.func_73075_a();
                if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                    bl = this.simLeftClick((EntityPlayer)this.myFakePlayer, this.func_70301_a(n), this.facing);
                }
            } else if (!this.leftClick && this.myFakePlayer.field_71074_e != null) {
                int n;
                bl = true;
                this.myFakePlayer.field_71071_by.field_70461_c = n = this.getNextStackIndex();
                this.myFakePlayer.tickItemInUse(this.func_70301_a(n));
                this.checkItemsUpdated();
            }
            if (bl) {
                this.drainEnergy(ACTIVATION_ENERGY);
            }
        } else {
            if (this.isActive) {
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            }
            this.isActive = false;
        }
        this.chargeEnergy();
    }

    public boolean doDeploy() {
        int n = this.getNextStackIndex();
        ItemStack itemStack = this.func_70301_a(n);
        this.updateFakePlayer(n);
        boolean bl = false;
        if (this.leftClick) {
            bl = this.simLeftClick((EntityPlayer)this.myFakePlayer, itemStack, this.facing);
        } else {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
            bl = this.simRightClick((EntityPlayer)this.myFakePlayer, itemStack, nArray[0], nArray[1], nArray[2], 1);
        }
        if (itemStack != null && itemStack.field_77994_a <= 0) {
            this.func_70299_a(n, null);
        }
        this.checkItemsUpdated();
        return bl;
    }

    public void checkItemsUpdated() {
        int n;
        ItemStack[] itemStackArray = this.myFakePlayer.field_71071_by.field_70462_a;
        for (n = 0; n < MAX_SLOT; ++n) {
            this.func_70299_a(n, itemStackArray[n]);
            if (this.inventory[n] == null || this.inventory[n].field_77994_a > 0) continue;
            this.inventory[n] = null;
            itemStackArray[n] = null;
        }
        int n2 = itemStackArray.length;
        while (n < n2) {
            if (InventoryHelper.addItemStackToInventory((ItemStack[])this.inventory, (ItemStack)itemStackArray[n], (int)0, (int)(MAX_SLOT - 1))) {
                itemStackArray[n] = null;
            }
            ++n;
        }
    }

    public int getNextStackIndex() {
        if (this.leftClick && this.myFakePlayer.field_71134_c.field_73094_o > -1 || this.myFakePlayer.field_71074_e != null) {
            return this.slotTracker;
        }
        if (this.tickSlot == 0) {
            return this.incrementTracker();
        }
        if (this.tickSlot == 1) {
            return this.getRandomStackIndex();
        }
        return 0;
    }

    public int getRandomStackIndex() {
        int n;
        int n2 = 0;
        this.tracker = new int[MAX_SLOT];
        for (n = 0; n < MAX_SLOT; ++n) {
            if (this.func_70301_a(n) == null) continue;
            this.tracker[n2++] = n;
        }
        if (n2 == 0) {
            return this.incrementTracker();
        }
        n = MathHelper.RANDOM.nextInt(n2 + 1);
        return n2 == n ? this.incrementTracker() : this.tracker[n];
    }

    public int incrementTracker() {
        int n;
        ++this.slotTracker;
        this.slotTracker %= MAX_SLOT;
        for (n = this.slotTracker; n < MAX_SLOT; ++n) {
            if (this.inventory[n] == null) continue;
            this.slotTracker = n;
            return this.slotTracker;
        }
        for (n = 0; n < this.slotTracker; ++n) {
            if (this.inventory[n] == null) continue;
            this.slotTracker = n;
            return this.slotTracker;
        }
        this.slotTracker = 0;
        return this.slotTracker;
    }

    public void updateFakePlayer(int n) {
        float f;
        this.myFakePlayer.field_71071_by.field_70462_a = new ItemStack[36];
        for (int i = 0; i < MAX_SLOT; ++i) {
            this.myFakePlayer.field_71071_by.field_70462_a[i] = this.func_70301_a(i);
        }
        double d = (double)((TileEntity)this).field_145851_c + 0.5;
        double d2 = (double)((TileEntity)this).field_145848_d - 1.1;
        double d3 = (double)((TileEntity)this).field_145849_e + 0.5;
        float f2 = this.angle == 0 ? 45.0f : (this.angle == 1 ? 0.0f : -45.0f);
        switch (this.facing) {
            case 0: {
                f2 = this.angle == 0 ? -90.0f : (this.angle == 1 ? 0.0f : 90.0f);
                f = 0.0f;
                d2 -= 0.51;
                break;
            }
            case 1: {
                f2 = this.angle == 0 ? 90.0f : (this.angle == 1 ? 0.0f : -90.0f);
                f = 0.0f;
                d2 += 1.51;
                break;
            }
            case 2: {
                f = 180.0f;
                d3 -= 0.51;
                d2 += 0.5;
                break;
            }
            case 3: {
                f = 0.0f;
                d3 += 0.51;
                d2 += 0.5;
                break;
            }
            case 4: {
                f = 90.0f;
                d -= 0.51;
                d2 += 0.5;
                break;
            }
            default: {
                f = -90.0f;
                d += 0.51;
                d2 += 0.5;
            }
        }
        this.myFakePlayer.func_70080_a(d, d2, d3, f, f2);
        this.myFakePlayer.isSneaking = this.actsSneaking;
        this.myFakePlayer.field_70129_M = -1.1f;
        this.myFakePlayer.setItemInHand(n);
        this.myFakePlayer.func_70071_h_();
    }

    @Override
    public boolean rotateBlock() {
        if (this.inWorld && ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
            this.myFakePlayer.field_71134_c.func_73073_c(nArray[0], nArray[1], nArray[2]);
            this.myFakePlayer.field_71134_c.field_73094_o = -1;
        }
        return super.rotateBlock();
    }

    public boolean simLeftClick(EntityPlayer entityPlayer, ItemStack itemStack, int n) {
        int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
        if (!block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, nArray[0], nArray[1], nArray[2])) {
            if (this.myFakePlayer.field_71134_c.field_73094_o == -1) {
                this.myFakePlayer.field_71134_c.func_73074_a(nArray[0], nArray[1], nArray[2], this.facing ^ 1);
            } else if (this.myFakePlayer.field_71134_c.field_73094_o >= 9) {
                this.myFakePlayer.field_71134_c.func_73082_a(nArray[0], nArray[1], nArray[2]);
                this.myFakePlayer.field_71134_c.field_73094_o = -1;
                if (itemStack != null) {
                    itemStack.func_77973_b().func_150894_a(itemStack, ((TileEntity)this).field_145850_b, block, nArray[0], nArray[1], nArray[2], (EntityLivingBase)this.myFakePlayer);
                }
            }
        } else {
            this.myFakePlayer.field_71134_c.func_73073_c(nArray[0], nArray[1], nArray[2]);
            this.myFakePlayer.field_71134_c.field_73094_o = -1;
            List list = ((TileEntity)this).field_145850_b.func_82733_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing), selectAttackable);
            if (list.size() == 0) {
                return false;
            }
            entityPlayer.func_71059_n((Entity)list.get(list.size() > 1 ? MathHelper.RANDOM.nextInt(list.size()) : 0));
        }
        return true;
    }

    public boolean simRightClick(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3, int n4) {
        if (entityPlayer.field_71074_e == null && !this.simRightClick2(entityPlayer, itemStack, n, n2, n3, n4) && itemStack != null) {
            List list = ((TileEntity)this).field_145850_b.func_72872_a(Entity.class, BlockHelper.getAdjacentAABBForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing));
            if (list.size() > 0 && entityPlayer.func_70998_m((Entity)list.get(list.size() > 1 ? MathHelper.RANDOM.nextInt(list.size() - 1) : 0))) {
                return true;
            }
            PlayerInteractEvent playerInteractEvent = ForgeEventFactory.onPlayerInteract((EntityPlayer)entityPlayer, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_AIR, (int)0, (int)0, (int)0, (int)-1, (World)((TileEntity)this).field_145850_b);
            if (playerInteractEvent.useItem == Event.Result.DENY) {
                return false;
            }
            ItemStack itemStack2 = itemStack.func_77957_a(((TileEntity)this).field_145850_b, entityPlayer);
            entityPlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, itemStack2 == null || itemStack2.field_77994_a <= 0 ? null : itemStack2);
        }
        return true;
    }

    public boolean simRightClick2(EntityPlayer entityPlayer, ItemStack itemStack, int n, int n2, int n3, int n4) {
        PlayerInteractEvent playerInteractEvent;
        int n5;
        float f = 0.5f;
        float f2 = 0.5f;
        float f3 = 0.5f;
        int n6 = n5 = this.facing == 1 ? 1 : -1;
        if (this.facing > 1) {
            if (this.angle == 0) {
                --n2;
            }
            if (this.angle == 2) {
                ++n2;
            }
        }
        if ((playerInteractEvent = ForgeEventFactory.onPlayerInteract((EntityPlayer)entityPlayer, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)n, (int)n2, (int)n3, (int)n4, (World)((TileEntity)this).field_145850_b)).isCanceled()) {
            return false;
        }
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(n, n2, n3);
        boolean bl = block.isAir((IBlockAccess)((TileEntity)this).field_145850_b, n, n2, n3);
        if (itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b().onItemUseFirst(itemStack, entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, n4, f, f2, f3)) {
            return true;
        }
        if ((!entityPlayer.func_70093_af() || entityPlayer.func_70694_bm() == null) && block.func_149727_a(((TileEntity)this).field_145850_b, n, n2, n3, entityPlayer, n4, f, f2, f3)) {
            return true;
        }
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ItemBlock ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3) && (bl ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, this.facing != 1 ? 1 : 0, f, f2, f3) : !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, 0, f, f2, f3)) : (bl ? !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, this.facing != 1 ? 1 : 0, f, f2, f3) && !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3) : !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2, n3, 0, f, f2, f3) && !itemStack.func_77943_a(entityPlayer, ((TileEntity)this).field_145850_b, n, n2 + n5, n3, this.facing != 1 ? 1 : 0, f, f2, f3))) {
            return false;
        }
        if (itemStack.field_77994_a <= 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(entityPlayer, itemStack));
            entityPlayer.field_71071_by.func_70299_a(this.myFakePlayer.field_71071_by.field_70461_c, null);
        }
        return true;
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this.actsSneaking = nBTTagCompound.func_74767_n("Sneaking");
        this.leftClick = nBTTagCompound.func_74767_n("LeftClick");
        this.tickSlot = nBTTagCompound.func_74771_c("TickSlot");
        this.angle = nBTTagCompound.func_74771_c("Angle");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("Sneaking", this.actsSneaking);
        nBTTagCompound.func_74757_a("LeftClick", this.leftClick);
        nBTTagCompound.func_74774_a("TickSlot", this.tickSlot);
        nBTTagCompound.func_74774_a("Angle", this.angle);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiActivator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerActivator(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getInvSlotCount() {
        return MAX_SLOT;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.actsSneaking = nBTTagCompound.func_74767_n("Sneaking");
        this.leftClick = nBTTagCompound.func_74767_n("LeftClick");
        this.tickSlot = nBTTagCompound.func_74771_c("TickSlot");
        this.angle = nBTTagCompound.func_74771_c("Angle");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Sneaking", this.actsSneaking);
        nBTTagCompound.func_74757_a("LeftClick", this.leftClick);
        nBTTagCompound.func_74774_a("TickSlot", this.tickSlot);
        nBTTagCompound.func_74774_a("Angle", this.angle);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.leftClick);
        packetCoFHBase.addBool(this.actsSneaking);
        packetCoFHBase.addByte(this.tickSlot);
        packetCoFHBase.addByte(this.angle);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.leftClick);
        packetCoFHBase.addBool(this.actsSneaking);
        packetCoFHBase.addByte(this.tickSlot);
        packetCoFHBase.addByte(this.angle);
        return packetCoFHBase;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.leftClick = packetCoFHBase.getBool();
        this.actsSneaking = packetCoFHBase.getBool();
        this.tickSlot = packetCoFHBase.getByte();
        this.angle = packetCoFHBase.getByte();
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.leftClick = packetCoFHBase.getBool();
        this.actsSneaking = packetCoFHBase.getBool();
        this.tickSlot = packetCoFHBase.getByte();
        this.angle = packetCoFHBase.getByte();
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 2;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    static {
        ACTIVATION_ENERGY = 20;
        MAX_SLOT = 9;
        selectAttackable = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity.func_70075_an();
            }
        };
    }
}

