/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.items.DiviningRodHigh;
import moze_intel.projecte.gameObjs.items.DiviningRodMedium;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.Comparators;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DiviningRodLow
extends ItemPE
implements IModeChanger {
    protected String[] modes;

    public DiviningRodLow() {
        this.func_77655_b("divining_rod_1");
        this.modes = new String[]{"3x3x3"};
    }

    protected DiviningRodLow(String[] modeDesc) {
        this.modes = modeDesc;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK)) {
            PlayerHelper.swingItem(player);
            ArrayList emcValues = Lists.newArrayList();
            long totalEmc = 0L;
            int numBlocks = 0;
            byte mode = this.getMode(stack);
            int depth = this.getDepthFromMode(mode);
            AxisAlignedBB box = WorldHelper.getDeepBox(new Coordinates(mop), ForgeDirection.getOrientation((int)mop.field_72310_e), depth);
            int i = (int)box.field_72340_a;
            while ((double)i <= box.field_72336_d) {
                int j = (int)box.field_72338_b;
                while ((double)j <= box.field_72337_e) {
                    int k = (int)box.field_72339_c;
                    while ((double)k <= box.field_72334_f) {
                        ArrayList drops;
                        Block block = world.func_147439_a(i, j, k);
                        if (block != Blocks.field_150350_a && (drops = block.getDrops(world, i, j, k, world.func_72805_g(i, j, k), 0)).size() != 0) {
                            ItemStack blockStack = (ItemStack)drops.get(0);
                            int blockEmc = EMCHelper.getEmcValue(blockStack);
                            if (blockEmc == 0) {
                                Map map = FurnaceRecipes.func_77602_a().func_77599_b();
                                for (Map.Entry entry : map.entrySet()) {
                                    int currentValue;
                                    if (entry == null || entry.getKey() == null || !ItemHelper.areItemStacksEqualIgnoreNBT((ItemStack)entry.getKey(), blockStack) || (currentValue = EMCHelper.getEmcValue((ItemStack)entry.getValue())) == 0) continue;
                                    if (!emcValues.contains(currentValue)) {
                                        emcValues.add(currentValue);
                                    }
                                    totalEmc += (long)currentValue;
                                }
                            } else {
                                if (!emcValues.contains(blockEmc)) {
                                    emcValues.add(blockEmc);
                                }
                                totalEmc += (long)blockEmc;
                            }
                            ++numBlocks;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            if (numBlocks == 0) {
                return stack;
            }
            int[] maxValues = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                maxValues[i2] = 1;
            }
            Collections.sort(emcValues, Comparators.INT_DESCENDING);
            int num = emcValues.size() >= 3 ? 3 : emcValues.size();
            for (int i3 = 0; i3 < num; ++i3) {
                maxValues[i3] = (Integer)emcValues.get(i3);
            }
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.divining.avgemc", new Object[]{numBlocks, totalEmc / (long)numBlocks}));
            if (this instanceof DiviningRodMedium) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.divining.maxemc", new Object[]{maxValues[0]}));
            }
            if (this instanceof DiviningRodHigh) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.divining.secondmax", new Object[]{maxValues[1]}));
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.divining.thirdmax", new Object[]{maxValues[2]}));
            }
        }
        return stack;
    }

    private int getDepthFromMode(byte mode) {
        String modeDesc = this.modes[mode];
        return Integer.parseInt(modeDesc.substring(0, modeDesc.indexOf(120))) - 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("divining1"));
    }

    @Override
    public byte getMode(ItemStack stack) {
        return stack.field_77990_d.func_74771_c("Mode");
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        if (this.modes.length == 1) {
            return;
        }
        if (this.getMode(stack) == this.modes.length - 1) {
            stack.field_77990_d.func_74774_a("Mode", (byte)0);
        } else {
            stack.field_77990_d.func_74774_a("Mode", (byte)(this.getMode(stack) + 1));
        }
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("pe.item.mode_switch", new Object[]{this.modes[this.getMode(stack)]}));
    }
}

