/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.lib.jse;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.mod.luaj.vm2.Varargs;
import org.mod.luaj.vm2.lib.OsLib;
import org.mod.luaj.vm2.lib.jse.JseProcess;

public class JseOsLib
extends OsLib {
    public static int EXEC_IOEXCEPTION = 1;
    public static int EXEC_INTERRUPTED = -2;
    public static int EXEC_ERROR = -3;

    @Override
    protected String getenv(String varname) {
        String s = System.getenv(varname);
        return s != null ? s : System.getProperty(varname);
    }

    @Override
    protected Varargs execute(String command) {
        int exitValue;
        try {
            exitValue = new JseProcess(command, null, (OutputStream)this.globals.STDOUT, (OutputStream)this.globals.STDERR).waitFor();
        }
        catch (IOException ioe) {
            exitValue = EXEC_IOEXCEPTION;
        }
        catch (InterruptedException e) {
            exitValue = EXEC_INTERRUPTED;
        }
        catch (Throwable t) {
            exitValue = EXEC_ERROR;
        }
        if (exitValue == 0) {
            return JseOsLib.varargsOf(TRUE, JseOsLib.valueOf("exit"), ZERO);
        }
        return JseOsLib.varargsOf(NIL, JseOsLib.valueOf("signal"), JseOsLib.valueOf(exitValue));
    }

    @Override
    protected void remove(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected void rename(String oldname, String newname) throws IOException {
        File f = new File(oldname);
        if (!f.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f.renameTo(new File(newname))) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected String tmpname() {
        try {
            File f = File.createTempFile(TMP_PREFIX, TMP_SUFFIX);
            return f.getName();
        }
        catch (IOException ioe) {
            return super.tmpname();
        }
    }
}

