/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.BlockHopper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraftforge.common.util.ForgeDirection;

public class ModItemDistributor
extends SocketModule {
    public ModItemDistributor(int id) {
        super(id, "eng_toolbox:itemDistributor");
    }

    @Override
    public String getLocalizedName() {
        return "Item Distributor";
    }

    public void getToolTip(List l) {
        l.add("Accepts items from automation and evenly");
        l.add("distributes them between internal inventories");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory to exclude");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"t", "b", Character.valueOf('t'), Items.field_151113_aN, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 1)});
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canInsertItems() {
        return true;
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.meta = 8;
    }

    @Override
    public int itemFill(ItemStack item, boolean doFill, SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean canIntake = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canIntake = false;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canIntake = false;
        }
        if (canIntake) {
            int taken = 0;
            ItemStack balancedItem = item.func_77946_l();
            int returned = 0;
            while (true) {
                if (config.tank == -1 || config.tank == 3 || config.tank == config.inventory) {
                    ts.nextTank(side.ordinal());
                    continue;
                }
                ItemStack bf = balancedItem.func_77946_l();
                bf.field_77994_a = 1;
                returned = ts.addItemInternal(bf, doFill, config.tank);
                balancedItem.field_77994_a -= returned;
                taken += returned;
                ts.nextTank(side.ordinal());
                if (returned == 0 || balancedItem.field_77994_a == 0) break;
            }
            return taken;
        }
        return 0;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.meta == 0) {
            config.meta = 16;
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            TileEntity t = ts.func_145831_w().func_147438_o(xo, yo, zo);
            if (t != null && t instanceof TileEntityHopper) {
                TileEntityHopper th = (TileEntityHopper)t;
                boolean canIntake = true;
                for (int i = 0; i < 3; ++i) {
                    if (config.rsControl[i] && ts.getRSControl(i)) {
                        canIntake = false;
                    }
                    if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                    canIntake = false;
                }
                int direction = BlockHopper.func_149918_b((int)ts.func_145831_w().func_72805_g(xo, yo, zo));
                if (ForgeDirection.getOrientation((int)direction).getOpposite() == side && canIntake) {
                    for (int i = 0; i < th.func_70302_i_(); ++i) {
                        if (th.func_70301_a(i) == null) continue;
                        ItemStack itemstack = th.func_70301_a(i).func_77946_l();
                        itemstack.field_77994_a = 1;
                        int added = ts.addItem(itemstack, true, side);
                        itemstack.field_77994_a = th.func_70301_a((int)i).field_77994_a - added;
                        if (itemstack.field_77994_a <= 0) {
                            itemstack = null;
                        }
                        th.func_70299_a(i, itemstack);
                    }
                }
            }
        } else {
            --config.meta;
        }
    }
}

