/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXWisp;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusTaintedShockwave
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.ENTROPY, 1000).add(Aspect.EARTH, 1000).add(Aspect.WATER, 1000).add(Aspect.ORDER, 500);
    public static IIcon depthIcon;
    public static IIcon ornIcon;

    public ItemFocusTaintedShockwave() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusTaintedShockwave");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusTaintedShockwave");
        depthIcon = ir.func_94245_a("taintedmagic:ItemFocusTaint_depth");
        ornIcon = ir.func_94245_a("taintedmagic:ItemFocusTaintedShockwave_orn");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack s) {
        return depthIcon;
    }

    public IIcon getOrnament(ItemStack s) {
        return ornIcon;
    }

    public String getSortingHelper(ItemStack s) {
        return "SHOCKWAVE" + super.getSortingHelper(s);
    }

    public int getFocusColor(ItemStack s) {
        return 13107455;
    }

    public AspectList getVisCost(ItemStack s) {
        return cost;
    }

    public int getActivationCooldown(ItemStack s) {
        return 15000;
    }

    public boolean isVisCostPerTick(ItemStack s) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack s) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public void func_77624_a(ItemStack s, EntityPlayer p, List l, boolean b) {
        super.func_77624_a(s, p, l, b);
        l.add(" ");
        l.add(EnumChatFormatting.BLUE + "+" + new String(this.isUpgradedWith(s, FocusUpgradeType.enlarge) ? Integer.toString(15 + this.getUpgradeLevel(s, FocusUpgradeType.enlarge)) : "15") + " " + StatCollector.func_74838_a((String)"text.radius"));
    }

    public ItemStack onFocusRightClick(ItemStack s, World w, EntityPlayer p, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)s.func_77973_b();
        int pot = wand.getFocusPotency(s);
        if (wand.consumeAllVis(s, p, this.getVisCost(s), true, false)) {
            List ents = w.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)p.field_70165_t, (double)p.field_70163_u, (double)p.field_70161_v, (double)(p.field_70165_t + 1.0), (double)(p.field_70163_u + 1.0), (double)(p.field_70161_v + 1.0)).func_72314_b(15.0 + (double)this.getUpgradeLevel(s, FocusUpgradeType.enlarge), 15.0 + (double)this.getUpgradeLevel(s, FocusUpgradeType.enlarge), 15.0 + (double)this.getUpgradeLevel(s, FocusUpgradeType.enlarge)));
            if (ents != null && ents.size() > 0) {
                for (int a = 0; a < ents.size(); ++a) {
                    EntityLivingBase e = (EntityLivingBase)ents.get(a);
                    if (e == p || !e.func_70089_S() || e.func_85032_ar()) continue;
                    double dist = TaintedMagicHelper.getDistanceTo(e.field_70165_t, e.field_70163_u, e.field_70161_v, p);
                    if (dist < 7.0) {
                        e.func_70097_a(DamageSource.field_76376_m, 2.0f);
                    }
                    Vector3 movement = TaintedMagicHelper.getDistanceBetween((Entity)e, (Entity)p);
                    e.func_70024_g(movement.x * 3.0, 0.8, movement.z * 3.0);
                }
            }
            w.func_72956_a((Entity)p, "taintedmagic:shockwave", 5.0f, 1.5f * (float)Math.random());
            if (w.field_72995_K) {
                this.spawnParticles(w, p);
            }
            return s;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World w, EntityPlayer p) {
        for (int i = 1; i < 360; ++i) {
            for (int j = 0; j < 4; ++j) {
                double r = 4.0;
                double xp = Math.cos((double)i * Math.PI / 180.0) * r;
                double zp = Math.sin((double)i * Math.PI / 180.0) * r;
                float red = 0.75f + w.field_73012_v.nextFloat() * 0.25f;
                float green = w.field_73012_v.nextFloat() * 0.5f;
                float blue = 0.75f + w.field_73012_v.nextFloat() * 0.25f;
                double off = (float)j * 0.25f;
                FXWisp ef = new FXWisp(w, p.field_70165_t + xp + off, p.field_70163_u - 1.0, p.field_70161_v + zp + off, 0.5f + (float)Math.random() * 0.25f, red, green, blue);
                ef.setGravity(0.0f);
                ef.shrink = true;
                ef.field_70145_X = true;
                ef.func_70024_g(xp * 0.3, 0.0, zp * 0.3);
                ParticleEngine.instance.addEffect(w, (EntityFX)ef);
            }
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack s, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
        }
        return null;
    }
}

