/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.PipeType;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.core.Position;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.utils.TransportUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsTeleport
extends PipeTeleport<PipeTransportItems> {
    private static final int ICON = 0;

    public PipeItemsTeleport(Item items) {
        super(new PipeTransportItems(), items, PipeType.ITEMS);
    }

    public void eventHandler(PipeEventItem.Entered event) {
        PipeTeleport otherPipe;
        int originalPipeNumber;
        if (this.getWorld().field_72995_K) {
            return;
        }
        ArrayList<PipeItemsTeleport> connectedTeleportPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
        if (connectedTeleportPipes.size() <= 0 || (this.state & 1) == 0) {
            return;
        }
        LinkedList<ForgeDirection> outputOrientations = new LinkedList<ForgeDirection>();
        int currentPipeNumber = originalPipeNumber = rand.nextInt(connectedTeleportPipes.size());
        boolean found = false;
        int numberOfTries = 0;
        do {
            ++numberOfTries;
            otherPipe = (PipeTeleport)connectedTeleportPipes.get(currentPipeNumber);
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!otherPipe.outputOpen(o)) continue;
                outputOrientations.add(o);
            }
            if (outputOrientations.size() <= 0) {
                if (++currentPipeNumber < connectedTeleportPipes.size()) continue;
                currentPipeNumber = 0;
                continue;
            }
            found = true;
        } while (numberOfTries < connectedTeleportPipes.size() && !found);
        if (!found) {
            return;
        }
        Position insertPoint = otherPipe.getPosition();
        insertPoint.x += 0.5;
        insertPoint.y += (double)TransportUtils.getPipeFloorOf((ItemStack)event.item.getItemStack());
        insertPoint.z += 0.5;
        insertPoint.moveForwards(0.5);
        event.item.setPosition(insertPoint.x, insertPoint.y, insertPoint.z);
        ForgeDirection newOrientation = otherPipe.getOpenOrientation().getOpposite();
        ((PipeTransportItems)otherPipe.transport).injectItem(event.item, newOrientation);
        Log.debug(event.item + " from " + this.getPosition() + " to " + otherPipe.getPosition() + " " + newOrientation);
        event.cancelled = true;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return 0;
    }
}

