/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.PipeTransportAdvancedWood;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.transport.TravelingItem;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsAdvancedWood
extends APPipe<PipeTransportAdvancedWood>
implements IEnergyHandler {
    protected RFBattery battery = new RFBattery(640, 640, 0);
    public final PipeTransportAdvancedWood transport;
    private int ticksSincePull = 0;

    public PipeItemsAdvancedWood(Item item) {
        super(new PipeTransportAdvancedWood(), item);
        this.transport = (PipeTransportAdvancedWood)((APPipe)this).transport;
    }

    private boolean shouldTick() {
        if (this.battery.getEnergyStored() >= 640) {
            return true;
        }
        return this.ticksSincePull >= 16 && this.battery.getEnergyStored() >= 10;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.container.func_145831_w().field_72995_K) {
            return;
        }
        ++this.ticksSincePull;
        if (this.shouldTick()) {
            World w = this.getWorld();
            int meta = this.container.func_145832_p();
            if (meta > 5) {
                return;
            }
            Position pos = new Position((double)this.container.field_145851_c, (double)this.container.field_145848_d, (double)this.container.field_145849_e, ForgeDirection.VALID_DIRECTIONS[meta]);
            pos.moveForwards(1.0);
            TileEntity tile = w.func_147438_o((int)pos.x, (int)pos.y, (int)pos.z);
            this.ticksSincePull = 0;
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                ItemStack extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
                if (extracted == null || extracted.field_77994_a == 0) {
                    return;
                }
                Position entityPos = new Position(pos.x + 0.5, pos.y + 0.25, pos.z + 0.5, pos.orientation.getOpposite());
                entityPos.moveForwards(0.5);
                TravelingItem entity = TravelingItem.make((double)entityPos.x, (double)entityPos.y, (double)entityPos.z, (ItemStack)extracted);
                this.transport.injectItem(entity, entityPos.orientation);
            }
            this.battery.setEnergy(0);
        }
    }

    public ItemStack checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        IInventory inv = InvUtils.getInventory((IInventory)inventory);
        int first = 0;
        int last = inv.func_70302_i_() - 1;
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] accessibleSlots = sidedInv.func_94128_d(from.ordinal());
            ItemStack result = this.checkExtractGeneric(sidedInv, doRemove, from, accessibleSlots);
            return result;
        }
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from, first, last);
        return result;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                int itemsExtracted = this.battery.getEnergyStored() / 10 >= slot.field_77994_a ? slot.field_77994_a : MathHelper.func_76128_c((double)(this.battery.getEnergyStored() / 10));
                this.battery.extractEnergy(itemsExtracted * 10, false);
                return inventory.func_70298_a(k, itemsExtracted);
            }
            return slot;
        }
        return null;
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from, int[] slots) {
        for (int i : slots) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.field_77994_a <= 0 || !this.canExtract(slot) || !inventory.func_102008_b(i, slot, from.ordinal())) continue;
            if (doRemove) {
                int itemsExtracted = this.battery.getEnergyStored() / 10 >= slot.field_77994_a ? slot.field_77994_a : MathHelper.func_76128_c((double)(this.battery.getEnergyStored() / 10));
                this.battery.extractEnergy(itemsExtracted * 10, false);
                return inventory.func_70298_a(i, itemsExtracted);
            }
            return slot;
        }
        return null;
    }

    public boolean canExtract(ItemStack item) {
        for (int i = 0; i < this.transport.func_70302_i_(); ++i) {
            ItemStack stack = this.transport.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item.func_77973_b()) continue;
            if (stack.func_77973_b().func_77645_m()) {
                return !this.transport.exclude;
            }
            if (stack.func_77960_j() != item.func_77960_j()) continue;
            return !this.transport.exclude;
        }
        return this.transport.exclude;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 6;
        }
        int metadata = this.container.func_145832_p();
        if (metadata == direction.ordinal()) {
            return 7;
        }
        return 6;
    }

    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection direction) {
        Item equipped;
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
            this.transport.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
            return true;
        }
        if (APConfiguration.filterRightclicks && AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        entityplayer.openGui((Object)AdditionalPipes.instance, 3, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public boolean doDrop() {
        Utils.preDestroyBlock((World)this.getWorld(), (int)this.container.field_145851_c, (int)this.container.field_145848_d, (int)this.container.field_145849_e);
        return true;
    }

    public boolean canConnectEnergy(ForgeDirection dir) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.battery.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.battery.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.battery.getMaxEnergyStored();
    }
}

