/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.utils.Log;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class APConfiguration {
    public static int chunkSightRange;
    public static boolean chunkSightAutorefresh;
    public static boolean enableDebugLog;
    public static int laserKeyCode;
    public static boolean allowWRRemove;
    public static float powerTransmittanceCfg;
    public static int waterPumpWaterPerTick;
    public static int gravityFeedPipeTicksPerPull;
    public static boolean enableTriggers;
    public static boolean filterRightclicks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigs(boolean init, File configFile) {
        if (!configFile.exists() && !init || configFile.exists() && init) {
            return;
        }
        Configuration config = new Configuration(configFile);
        try {
            config.load();
            Property powerTransmittance = config.get("general", "powerTransmittance", 90);
            powerTransmittance.comment = "Percentage of power a power teleport pipe transmits. Between 0 and 100.";
            powerTransmittanceCfg = (float)powerTransmittance.getInt() / 100.0f;
            if ((double)powerTransmittanceCfg > 1.0) {
                powerTransmittanceCfg = 0.99f;
            } else if ((double)powerTransmittanceCfg < 0.0) {
                powerTransmittanceCfg = 0.0f;
            }
            Property chunkSightRangeProperty = config.get("general", "chunkSightRange", 8);
            chunkSightRangeProperty.comment = "Range of chunk load boundaries.";
            chunkSightRange = chunkSightRangeProperty.getInt();
            Property laserKey = config.get("general", "laserKeyChar", 68);
            laserKey.comment = "Default key to toggle chunk load boundaries.";
            laserKeyCode = laserKey.getInt();
            Property filterRightclicksProperty = config.get("general", "filterRightclicks", false);
            filterRightclicksProperty.comment = "When right clicking on something with a gui, do not show the gui if you have a pipe in your hand";
            filterRightclicks = filterRightclicksProperty.getBoolean();
            Property enableDebugLogProperty = config.get("general", "enableDebugLog", false);
            enableDebugLogProperty.comment = "Enable debug logging for development";
            enableDebugLog = enableDebugLogProperty.getBoolean();
            Property allowWRRemoveProperty = config.get("general", "allowWRRemove", true);
            allowWRRemoveProperty.comment = "Turn on recipes for removing the redstone and sealant from pipes to turn them back to transport pipes";
            allowWRRemove = allowWRRemoveProperty.getBoolean();
            Property waterPerTickProperty = config.get("general", "waterPumpWaterPerTick", 90);
            waterPerTickProperty.comment = "Amount of water the Water Pump Pipe produces in millibuckets/tick";
            waterPumpWaterPerTick = waterPerTickProperty.getInt();
            Property gpPullRateProperty = config.get("general", "gravityFeedPipeTicksPerPull", 48);
            gpPullRateProperty.comment = "How many ticks the Gravity Feed Pipe needs to extract an item";
            gravityFeedPipeTicksPerPull = gpPullRateProperty.getInt();
        }
        catch (Exception e) {
            Log.error("Error loading Additional Pipes configs." + e);
        }
        finally {
            config.save();
        }
    }

    static {
        chunkSightAutorefresh = true;
        enableTriggers = true;
        filterRightclicks = false;
    }
}

