/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block.listeners;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.IPlacementListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListenerBuilder;
import com.builtbroken.mc.lib.helper.BlockUtility;
import com.builtbroken.mc.seven.framework.block.listeners.TileListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class RotatableListener
extends TileListener
implements IPlacementListener,
IBlockListener {
    @Override
    public void onPlacedBy(EntityLivingBase entityLivingBase, ItemStack stack) {
        byte rotation = BlockUtility.determineRotation(entityLivingBase.field_70177_z);
        if (!this.setMeta(rotation, 3)) {
            Engine.logger().error("Failed to set rotation for block at " + this.x() + "x," + this.y() + "y," + this.z() + "z,");
        }
    }

    @Override
    public List<String> getListenerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("placement");
        return list;
    }

    public static class Builder
    implements ITileEventListenerBuilder {
        @Override
        public ITileEventListener createListener(Block block) {
            return new RotatableListener();
        }

        @Override
        public String getListenerKey() {
            return "rotation";
        }
    }
}

