/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.struct;

import com.builtbroken.mc.framework.json.struct.JsonConditional;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonForLoop {
    public static final int MAX_FOR_LOOPS = 100;

    public static boolean hasLoops(JsonObject currentJsonObject) {
        if (currentJsonObject != null) {
            for (Map.Entry elementEntry : currentJsonObject.entrySet()) {
                String key = (String)elementEntry.getKey();
                if (key.contains(":")) {
                    String[] split = key.split(":");
                    key = split[0];
                }
                if (key.equalsIgnoreCase("for")) {
                    return true;
                }
                if (!key.equalsIgnoreCase("forEach")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean handleLoops(JsonObject currentJsonObject, Consumer<JsonObject> action) {
        boolean handled = false;
        for (Map.Entry elementEntry : currentJsonObject.entrySet()) {
            String key = (String)elementEntry.getKey();
            String subKey = "";
            if (key.contains(":")) {
                String[] split = key.split(":");
                if (split.length > 2) {
                    throw new IllegalArgumentException("JsonForLoop: Loop entry name for '" + key + "' should only contain one ':'");
                }
                key = split[0];
                subKey = split[1];
            }
            if (key.equalsIgnoreCase("for")) {
                JsonForLoop.generateDataForLoop(((JsonElement)elementEntry.getValue()).getAsJsonObject(), action);
                handled = true;
                continue;
            }
            if (!key.equalsIgnoreCase("forEach")) continue;
            JsonForLoop.generateDataForEachLoop(((JsonElement)elementEntry.getValue()).getAsJsonObject(), action);
            handled = true;
        }
        return handled;
    }

    public static void generateDataForLoop(JsonObject currentJsonObject, Consumer<JsonObject> action) {
        Objects.requireNonNull(action);
        ArrayList<JsonObject> elements = new ArrayList<JsonObject>();
        JsonForLoop.generateDataForLoop(currentJsonObject, elements);
        for (JsonObject object : elements) {
            action.accept(object);
        }
    }

    public static void generateDataForLoop(JsonObject currentJsonObject, List<JsonObject> states) {
        JsonForLoop.generateDataForLoop(currentJsonObject, states, new HashMap<String, String>(), 0);
    }

    public static void generateDataForLoop(JsonObject currentJsonObject, List<JsonObject> states, HashMap<String, String> injectionKeys, int depth) {
        String s;
        if (!currentJsonObject.has("start") || !currentJsonObject.has("end")) {
            throw new RuntimeException("For loop expects 'start' and 'end' values in JSON object structure");
        }
        JsonPrimitive startData = currentJsonObject.getAsJsonPrimitive("start");
        JsonPrimitive endData = currentJsonObject.getAsJsonPrimitive("end");
        int start = 0;
        int end = 0;
        if (startData.isNumber()) {
            start = startData.getAsInt();
        } else {
            s = startData.getAsString();
            s = JsonForLoop.injectValues(s, injectionKeys);
            start = Integer.parseInt(s);
        }
        if (endData.isNumber()) {
            end = endData.getAsInt();
        } else {
            s = endData.getAsString();
            s = JsonForLoop.injectValues(s, injectionKeys);
            end = Integer.parseInt(s);
        }
        String id = "number";
        if (currentJsonObject.has("id")) {
            id = currentJsonObject.getAsJsonPrimitive("id").getAsString();
        }
        if (depth != 0 && "number".equalsIgnoreCase(id)) {
            throw new RuntimeException("Nested for loops must each have there own unique id so not to overlap with default");
        }
        if (start >= end) {
            throw new IllegalArgumentException("Start can not be greater than or equal to end for a for loop.");
        }
        for (int i = start; i <= end; ++i) {
            injectionKeys.put(id, "" + i);
            JsonForLoop.handle(currentJsonObject, states, injectionKeys, depth);
        }
        injectionKeys.remove(id);
    }

    public static void generateDataForEachLoop(JsonObject currentJsonObject, Consumer<JsonObject> action) {
        Objects.requireNonNull(action);
        ArrayList<JsonObject> elements = new ArrayList<JsonObject>();
        JsonForLoop.generateDataForEachLoop(currentJsonObject, elements);
        for (JsonObject object : elements) {
            action.accept(object);
        }
    }

    public static void generateDataForEachLoop(JsonObject currentJsonObject, List<JsonObject> states) {
        JsonForLoop.generateDataForEachLoop(currentJsonObject, states, new HashMap<String, String>(), 0);
    }

    public static void generateDataForEachLoop(JsonObject currentJsonObject, List<JsonObject> states, HashMap<String, String> injectionKeys, int depth) {
        if (!currentJsonObject.has("values") || !currentJsonObject.get("values").isJsonArray()) {
            throw new RuntimeException("ForEach must define a JSON array of values to loop over");
        }
        JsonArray values = currentJsonObject.getAsJsonArray("values");
        for (JsonElement e : values) {
            if (e.isJsonObject()) {
                JsonObject valueObject = e.getAsJsonObject();
                HashMap newKeys = new HashMap();
                for (Map.Entry entry : valueObject.entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase("runCondition")) continue;
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        newKeys.put(entry.getKey(), JsonForLoop.injectValues(((JsonElement)entry.getValue()).getAsString(), injectionKeys));
                        continue;
                    }
                    throw new RuntimeException("ForEach values keys must be JSON primitives (string, int, double, float, etc)");
                }
                injectionKeys.putAll(newKeys);
                boolean run = true;
                if (valueObject.has("runCondition")) {
                    JsonElement runCondition = valueObject.get("runCondition");
                    run = JsonConditional.isConditionalTrue(runCondition, injectionKeys);
                }
                if (run) {
                    JsonForLoop.handle(currentJsonObject, states, injectionKeys, depth);
                }
                for (String key : newKeys.keySet()) {
                    injectionKeys.remove(key);
                }
                continue;
            }
            throw new RuntimeException("ForEach values must be define as a JSON object containing key:value");
        }
    }

    public static void handle(JsonObject json, List<JsonObject> states, HashMap<String, String> injectionKeys, int depth) {
        for (Map.Entry entry : json.entrySet()) {
            JsonObject object;
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            String key = (String)entry.getKey();
            if (key.contains(":")) {
                key = key.split(":")[0];
            }
            if (key.equalsIgnoreCase("for")) {
                if (depth >= 100) {
                    throw new RuntimeException("Too many for loops while building json element data, the limit is set to 100 to prevent infinite loop.");
                }
                object = JsonForLoop.buildObjectFromTemplate(((JsonElement)entry.getValue()).getAsJsonObject(), injectionKeys, false);
                JsonForLoop.generateDataForLoop(object, states, injectionKeys, depth + 1);
                continue;
            }
            if (key.equalsIgnoreCase("forEach")) {
                object = JsonForLoop.buildObjectFromTemplate(((JsonElement)entry.getValue()).getAsJsonObject(), injectionKeys, false);
                JsonForLoop.generateDataForEachLoop(object, states, injectionKeys, depth + 1);
                continue;
            }
            if (key.equalsIgnoreCase("data") || key.equalsIgnoreCase("state")) {
                states.add(JsonForLoop.buildObjectFromTemplate(((JsonElement)entry.getValue()).getAsJsonObject(), injectionKeys, true));
                continue;
            }
            throw new IllegalArgumentException("ForLoop could not understate layout, expected 'for', 'forEach', or 'data' entries in JSON object");
        }
    }

    public static JsonObject buildObjectFromTemplate(JsonObject template, HashMap<String, String> injectionKeys, boolean doNested) {
        JsonObject state = new JsonObject();
        for (Map.Entry jsonEntry : template.entrySet()) {
            state.add((String)jsonEntry.getKey(), JsonForLoop.buildElementFromTemplate((JsonElement)jsonEntry.getValue(), injectionKeys, doNested));
        }
        return state;
    }

    public static JsonElement buildElementFromTemplate(JsonElement value, HashMap<String, String> injectionKeys, boolean doNested) {
        if (value instanceof JsonPrimitive) {
            if (((JsonPrimitive)value).isString()) {
                return new JsonPrimitive(JsonForLoop.injectValues(value.getAsString(), injectionKeys));
            }
            if (((JsonPrimitive)value).isNumber()) {
                return new JsonPrimitive(value.getAsNumber());
            }
            if (((JsonPrimitive)value).isBoolean()) {
                return new JsonPrimitive(Boolean.valueOf(value.getAsBoolean()));
            }
        } else {
            if (value instanceof JsonObject) {
                return JsonForLoop.buildObjectFromTemplate(value.getAsJsonObject(), injectionKeys, doNested);
            }
            if (value instanceof JsonArray) {
                JsonArray clone = new JsonArray();
                JsonArray array = value.getAsJsonArray();
                for (JsonElement element : array) {
                    clone.add(JsonForLoop.buildElementFromTemplate(element, injectionKeys, doNested));
                }
                return clone;
            }
        }
        return value;
    }

    public static String injectValues(String string, HashMap<String, String> injectionKeys) {
        String s = string;
        for (Map.Entry<String, String> entry : injectionKeys.entrySet()) {
            String value = entry.getValue();
            s = s.replace("%" + entry.getKey() + "%", value);
        }
        return s;
    }
}

