/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.entity.effect;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class EntityEffect
implements ISave {
    public final String id;
    public final String mod;
    public boolean isAlive = true;
    public int tick = 0;
    public Entity entity;
    public IWorld world;

    public EntityEffect(String mod, String id) {
        this.mod = mod;
        this.id = id;
    }

    public boolean onWorldTick() {
        return !this.isAlive;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        return compound;
    }

    @Override
    public void load(NBTTagCompound compound) {
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
        this.world = Engine.getWorld(world.field_73011_w.field_76574_g);
    }

    public abstract void merge(EntityEffect var1);

    public String getUnlocalizedName() {
        return "entity.effect." + this.mod + ":" + this.id + ".name";
    }

    public String getDisplayName() {
        String translation = LanguageUtility.getLocal(this.getUnlocalizedName());
        if (translation != null) {
            return !(translation = translation.trim()).isEmpty() ? translation : this.getUnlocalizedName();
        }
        return this.getUnlocalizedName();
    }

    protected boolean isServer() {
        return !this.world.isServer();
    }

    protected boolean isClient() {
        return this.world.isClient();
    }
}

