/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client.json.render.state;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.debug.IJsonDebugDisplay;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import java.awt.Color;
import java.util.List;

public abstract class RenderState
extends JsonGenData
implements IRenderState,
IJsonDebugDisplay {
    public final String id;
    public String parent;
    public String color;
    public IRenderState parentState;
    private int colorCache = -2;

    public RenderState(String id) {
        super(null);
        this.id = id;
    }

    @Override
    public int getColorForTexture(int side) {
        block12: {
            if (this.colorCache != -2) {
                return this.colorCache;
            }
            if (this.color != null) {
                if (this.color.contains(",")) {
                    try {
                        String[] split = this.color.split(",");
                        if (split.length == 3) {
                            this.colorCache = new Color(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim())).getRGB();
                            break block12;
                        }
                        if (split.length == 4) {
                            this.colorCache = new Color(Integer.parseInt(split[0].trim()), Integer.parseInt(split[1].trim()), Integer.parseInt(split[2].trim()), Integer.parseInt(split[3].trim())).getRGB();
                            break block12;
                        }
                        Engine.logger().error("RenderState#getColorForTexture(" + side + ") Failed to convert [" + this.color + "] to color. Expected to see number separated list of 3-4 items (red, green, blue, alpha) value 0-255");
                        this.colorCache = -1;
                    }
                    catch (NumberFormatException e) {
                        this.colorCache = -1;
                        Engine.logger().error("RenderState#getColorForTexture(" + side + ") Failed to convert [" + this.color + "] to color due to invalid number. Expected to see number separated list of 3-4 items (red, green, blue, alpha) value 0-255");
                    }
                } else {
                    if (ClientDataHandler.INSTANCE.canSupportColor(this.color)) {
                        return ClientDataHandler.INSTANCE.getColorAsInt(this.color);
                    }
                    try {
                        this.colorCache = Integer.parseInt(this.color);
                        if (this.colorCache < 0) {
                            this.colorCache = -1;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.colorCache = -1;
                        Engine.logger().error("RenderState#getColorForTexture(" + side + ") Failed to convert [" + this.color + "] to color.");
                    }
                }
            }
        }
        return -1;
    }

    @Override
    public String getContentID() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public String getUniqueID() {
        return this.id;
    }

    @Override
    public void addDebugLines(List<String> lines) {
        lines.add("ParentID: " + this.parent);
        lines.add("Parent: " + this.parentState);
    }

    @Override
    public IRenderState getParent() {
        return this.parentState;
    }
}

