/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission.Thorium;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Base.TileEntityNuclearCore;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.Thorium.TileEntityFuelDump;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import Reika.ReactorCraft.TileEntities.TileEntityWastePipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityThoriumCore
extends TileEntityNuclearCore
implements InertIInv,
IFluidHandler,
PipeConnector,
IPipeConnection {
    private static final int CYCLE_AMOUNT = 100;
    public static final int FUEL_DUMP_TEMPERATURE = 1100;
    private final HybridTank fuelTank = new HybridTank("thoriumfuel", 4000);
    private final HybridTank fuelTankOut = new HybridTank("thoriumfuelout", 4000);
    private final HybridTank wasteTank = new HybridTank("thoriumwaste", 1000);
    private StepTimer timer2 = new StepTimer(20);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.clearInventory((IInventory)this);
            this.fuelTank.addLiquid(100, ReactorCraft.LIFBe_fuel);
            this.wasteTank.empty();
            this.temperature = 400;
        }
        this.timer2.update();
        if (this.timer2.checkCap()) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            }
        }
        if (!world.field_72995_K) {
            this.feedFluid();
        }
    }

    private void feedFluid() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityThoriumCore) {
            int amt = ((TileEntityThoriumCore)tile).feedFluidIn(this.fuelTank.getFluid(), 0);
            if (amt > 0) {
                this.fuelTank.removeLiquid(amt);
            }
            if ((amt = ((TileEntityThoriumCore)tile).feedFluidIn(this.fuelTankOut.getFluid(), 1)) > 0) {
                this.fuelTankOut.removeLiquid(amt);
            }
            if ((amt = ((TileEntityThoriumCore)tile).feedFluidIn(this.wasteTank.getFluid(), 2)) > 0) {
                this.wasteTank.removeLiquid(amt);
            }
        }
    }

    private int feedFluidIn(FluidStack is, int tankType) {
        if (is == null) {
            return 0;
        }
        HybridTank tank = null;
        switch (tankType) {
            case 0: {
                tank = this.fuelTank;
                break;
            }
            case 1: {
                tank = this.fuelTankOut;
                break;
            }
            case 2: {
                tank = this.wasteTank;
            }
        }
        if (tank == null) {
            return 0;
        }
        Fluid f = is.getFluid();
        if (tank.getActualFluid() != null && tank.getActualFluid() != f) {
            return 0;
        }
        int add = Math.min(tank.getRemainingSpace(), is.amount);
        tank.addLiquid(add, f);
        return add;
    }

    int dumpFuel(TileEntityFuelDump te, int max) {
        int amt = Math.min(max, this.fuelTank.getLevel());
        if (amt > 0) {
            this.fuelTank.removeLiquid(amt);
            ReactorAchievements.THORIUMDUMP.triggerAchievement(this.getPlacer());
        }
        return amt;
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq == TileEntityWaterCell.LiquidStates.LITHIUM;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return false;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        super.onNeutron(e, world, x, y, z);
        if (!world.field_72995_K && e.getType().canTriggerFission() && e.getType() != EntityNeutron.NeutronType.BREEDER && ReikaRandomHelper.doWithChance((double)this.getNeutronInteractionChance())) {
            if (this.checkPoisonedChance()) {
                return true;
            }
            if (ReikaRandomHelper.doWithChance((double)this.getNeutronChance()) && this.hasFuel()) {
                this.fuelTank.removeLiquid(100);
                this.fuelTankOut.addLiquid(100, FluidRegistry.getFluid((String)"rc hot lifbe"));
                this.temperature += 20;
                this.spawnNeutronBurst(world, x, y, z);
                if (ReikaRandomHelper.doWithChance((double)5.0)) {
                    this.addWaste();
                }
            }
            return true;
        }
        return false;
    }

    private double getNeutronInteractionChance() {
        return ReikaMathLibrary.cosInterpolation((double)this.getMinTemperature(), (double)this.getMaxTemperature(), (double)this.temperature);
    }

    private double getNeutronChance() {
        return 25.0 - 20.0 * Math.sqrt((double)(this.temperature - this.getMinTemperature()) / (double)(this.getMaxTemperature() - this.getMinTemperature()));
    }

    public boolean hasFuel() {
        return this.fuelTank.getLevel() >= 100;
    }

    @Override
    protected boolean checkPoisonedChance() {
        return ReikaRandomHelper.doWithChance((double)(0.875 * Math.pow((double)this.wasteTank.getLevel() / (double)this.wasteTank.getCapacity(), 1.6)));
    }

    @Override
    protected void addWaste() {
        this.wasteTank.addLiquid(50, FluidRegistry.getFluid((String)"rc nuclear waste"));
    }

    @Override
    public boolean isFissile() {
        return false;
    }

    private int getMinTemperature() {
        return 400;
    }

    @Override
    public int getMaxTemperature() {
        return 1200;
    }

    @Override
    public boolean canRemoveItem(int slot, ItemStack is) {
        return false;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.THORIUM.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.fuelTank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.canDrain(from, resource.getFluid())) {
            return from.offsetY == 0 ? (this.isWastePipe(from) ? this.wasteTank.drain(resource.amount, doDrain) : null) : this.fuelTankOut.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return from.offsetY == 0 ? (this.isWastePipe(from) ? this.wasteTank.drain(maxDrain, doDrain) : null) : this.fuelTankOut.drain(maxDrain, doDrain);
        }
        return null;
    }

    private boolean isWastePipe(ForgeDirection from) {
        return this.getAdjacentTileEntity(from) instanceof TileEntityWastePipe;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && fluid == FluidRegistry.getFluid((String)"rc lifbe fuel");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && (ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.wasteTank) || ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.fuelTankOut));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fuelTank.getInfo(), this.fuelTankOut.getInfo(), this.wasteTank.getInfo()};
    }

    @DependentMethodStripper.ModDependent(value=ModList.BCTRANSPORT)
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.FLUID ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.FUELLINE;
    }

    public boolean canConnectToPipeOnSide(MachineRegistry m, ForgeDirection side) {
        return side.offsetY == 0 ? false : m.isStandardPipe();
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.OUTPUT;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.fuelTank.readFromNBT(NBT);
        this.fuelTankOut.readFromNBT(NBT);
        this.wasteTank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.fuelTank.writeToNBT(NBT);
        this.fuelTankOut.writeToNBT(NBT);
        this.wasteTank.writeToNBT(NBT);
    }
}

