/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Renders;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.ReactorCraft.Base.ReactorRenderBase;
import Reika.ReactorCraft.Models.ModelProcessor;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityUProcessor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderProcessor
extends ReactorRenderBase {
    private ModelProcessor ProcessorModel = new ModelProcessor();

    public void renderTileEntityUProcessorAt(TileEntityUProcessor tile, double par2, double par4, double par6, float par8) {
        ModelProcessor var14 = this.ProcessorModel;
        this.bindTextureByName("/Reika/ReactorCraft/Textures/TileEntity/processor.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glTranslatef((float)0.0f, (float)0.01f, (float)0.0f);
        float var13 = 0.0f;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var13 = 270.0f;
                    break;
                }
                case 1: {
                    var13 = 90.0f;
                    break;
                }
                case 2: {
                    var13 = 0.0f;
                    break;
                }
                case 3: {
                    var13 = 180.0f;
                }
            }
        }
        GL11.glRotatef((float)var13, (float)0.0f, (float)1.0f, (float)0.0f);
        var14.renderAll((TileEntity)tile, null, -tile.phi, 0.0f);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        TileEntityUProcessor te = (TileEntityUProcessor)tile;
        if (this.doRenderModel(te)) {
            this.renderTileEntityUProcessorAt(te, par2, par4, par6, par8);
        }
        if (te.isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            this.renderLiquids((TileEntityUProcessor)tile, par2, par4, par6);
        }
    }

    private void renderLiquids(TileEntityUProcessor tile, double par2, double par4, double par6) {
        for (int i = 0; i < 3; ++i) {
            Fluid f = null;
            int amount = 0;
            switch (i) {
                case 0: {
                    f = tile.getInputFluid();
                    amount = tile.getInput();
                    break;
                }
                case 1: {
                    f = tile.getIntermediateFluid();
                    amount = tile.getIntermediate();
                    break;
                }
                case 2: {
                    amount = tile.getOutput();
                    f = tile.getOutputFluid();
                }
            }
            if (f == null || amount == 0) continue;
            FluidStack liquid = new FluidStack(f, 1);
            int[] displayList = ReikaLiquidRenderer.getGLLists((FluidStack)liquid, (World)tile.field_145850_b, (boolean)false);
            if (displayList == null) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            ReikaLiquidRenderer.setFluidColor((FluidStack)liquid);
            GL11.glTranslated((double)par2, (double)par4, (double)par6);
            GL11.glScaled((double)this.getLiquidScaleX(tile, liquid, i), (double)this.getLiquidScaleY(tile, liquid, i), (double)this.getLiquidScaleZ(tile, liquid, i));
            GL11.glTranslated((double)this.getLiquidOffsetX(tile, liquid, i), (double)this.getLiquidOffsetY(tile, liquid, i), (double)this.getLiquidOffsetZ(tile, liquid, i));
            GL11.glTranslated((double)0.0, (double)0.01, (double)0.0);
            GL11.glScaled((double)0.99, (double)0.98, (double)0.99);
            GL11.glCallList((int)displayList[(int)((double)amount / 3000.0 * 99.0)]);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    private double getLiquidScaleX(TileEntityUProcessor tile, FluidStack liq, int i) {
        if (i == 0 && tile.func_145832_p() >= 2) {
            return 0.5;
        }
        if (i == 0 && tile.func_145832_p() < 2) {
            return 0.5625;
        }
        if (i == 1 && tile.func_145832_p() >= 2) {
            return 0.5;
        }
        if (i == 1 && tile.func_145832_p() < 2) {
            return 0.5625;
        }
        if (i == 2 && tile.func_145832_p() >= 2) {
            return 0.875;
        }
        if (i == 2 && tile.func_145832_p() < 2) {
            return 0.4375;
        }
        return 1.0;
    }

    private double getLiquidScaleY(TileEntityUProcessor tile, FluidStack liq, int i) {
        if (i == 2) {
            return 0.7857142857142857;
        }
        return 1.0;
    }

    private double getLiquidScaleZ(TileEntityUProcessor tile, FluidStack liq, int i) {
        if (i == 0 && tile.func_145832_p() < 2) {
            return 0.5;
        }
        if (i == 0 && tile.func_145832_p() >= 2) {
            return 0.5625;
        }
        if (i == 1 && tile.func_145832_p() < 2) {
            return 0.5;
        }
        if (i == 1 && tile.func_145832_p() >= 2) {
            return 0.5625;
        }
        if (i == 2 && tile.func_145832_p() >= 2) {
            return 0.4375;
        }
        if (i == 2 && tile.func_145832_p() < 2) {
            return 0.875;
        }
        return 1.0;
    }

    private double getLiquidOffsetX(TileEntityUProcessor tile, FluidStack liq, int i) {
        if (i == 0 && tile.func_145832_p() == 0) {
            return 0.775;
        }
        if (i == 0 && tile.func_145832_p() == 3) {
            return 1.0;
        }
        if (i == 1 && tile.func_145832_p() == 0) {
            return 0.775;
        }
        if (i == 1 && tile.func_145832_p() == 2) {
            return 1.0;
        }
        if (i == 2 && tile.func_145832_p() >= 2) {
            return 0.0625;
        }
        if (i == 2 && tile.func_145832_p() == 1) {
            return 1.25;
        }
        return 0.0;
    }

    private double getLiquidOffsetY(TileEntityUProcessor tile, FluidStack liq, int i) {
        return 0.0;
    }

    private double getLiquidOffsetZ(TileEntityUProcessor tile, FluidStack liq, int i) {
        if (i == 0 && tile.func_145832_p() == 2) {
            return 0.775;
        }
        if (i == 0 && tile.func_145832_p() == 0) {
            return 1.0;
        }
        if (i == 1 && tile.func_145832_p() == 2) {
            return 0.775;
        }
        if (i == 1 && tile.func_145832_p() == 1) {
            return 1.0;
        }
        if (i == 2 && tile.func_145832_p() == 3) {
            return 1.25;
        }
        if (i == 2 && tile.func_145832_p() < 2) {
            return 0.0625;
        }
        return 0.0;
    }

    public String getImageFileName(RenderFetcher te) {
        return "Processor.png";
    }
}

