/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.BlockRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum RadiationShield {
    STEEL("Steel", 90.0, 95.0, new BlockKey(ItemStacks.steelblock)),
    CONCRETE("Concrete", 60.0, 70.0, new BlockKey(ReactorBlocks.MATS.getBlockInstance(), MatBlocks.CONCRETE.ordinal())),
    WATER("Water", 30.0, 10.0, new BlockKey(Blocks.field_150355_j), new BlockKey((Block)Blocks.field_150358_i)),
    BEDINGOT("Bedrock Ingot", 97.5, 100.0, new BlockKey(ItemStacks.bedingotblock)),
    LEAD("Lead", 75.0, 50.0, "blockLead"),
    OBSIDIAN("Obsidian", 50.0, 80.0, new BlockKey(Blocks.field_150343_Z)),
    BLASTGLASS("Blast Glass", 80.0, 20.0, new BlockKey(BlockRegistry.BLASTGLASS.getBlockInstance()));

    public final double neutronAbsorbChance;
    public final double radiationDeflectChance;
    public final String displayName;
    private final ArrayList<BlockKey> blocks = new ArrayList();
    private static final BlockMap<RadiationShield> blockMap;
    public static final RadiationShield[] shieldList;

    private RadiationShield(String s, double n2, double r, BlockKey ... bks) {
        this.displayName = s;
        this.neutronAbsorbChance = n2;
        this.radiationDeflectChance = r;
        for (int i = 0; i < bks.length; ++i) {
            BlockKey bk = bks[i];
            this.blocks.add(bk);
        }
    }

    private RadiationShield(String s, double n2, double r, String ... ores) {
        this(s, n2, r, RadiationShield.getBlockKeysForOreDicts(ores));
    }

    private static BlockKey[] getBlockKeysForOreDicts(String[] ores) {
        ArrayList<BlockKey> li = new ArrayList<BlockKey>();
        for (int i = 0; i < ores.length; ++i) {
            String s = ores[i];
            ArrayList items = OreDictionary.getOres((String)s);
            for (ItemStack is : items) {
                Block b = Block.func_149634_a((Item)is.func_77973_b());
                if (b == null) continue;
                li.add(new BlockKey(b, is.func_77960_j()));
            }
        }
        return li.toArray(new BlockKey[li.size()]);
    }

    public static RadiationShield getFrom(Block b, int meta) {
        return (RadiationShield)((Object)blockMap.get(b, meta));
    }

    public static String getDataAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < shieldList.length; ++i) {
            RadiationShield type = shieldList[i];
            sb.append(type.displayName + ": " + type.neutronAbsorbChance + "% neutron absorption, " + type.radiationDeflectChance + " radiation containment");
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        blockMap = new BlockMap();
        shieldList = RadiationShield.values();
        for (int i = 0; i < shieldList.length; ++i) {
            RadiationShield rs = shieldList[i];
            for (BlockKey bk : rs.blocks) {
                blockMap.put(bk, (Object)rs);
            }
        }
    }
}

