/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.ChromatiCraft.API.AcceleratorBlacklist;
import Reika.ChromatiCraft.API.CrystalPotionInterface;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.CreativeTabSorter;
import Reika.DragonAPI.Auxiliary.Trackers.IntegrityChecker;
import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerFirstTimeTracker;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.Auxiliary.Trackers.PotionCollisionTracker;
import Reika.DragonAPI.Auxiliary.Trackers.RetroGenController;
import Reika.DragonAPI.Auxiliary.Trackers.SuggestedModsTracker;
import Reika.DragonAPI.Auxiliary.Trackers.VanillaIntegrityTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Base.EnumOreBlock;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.CustomStringDamageSource;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.PacketHandler;
import Reika.DragonAPI.Interfaces.Registry.BlockEnum;
import Reika.DragonAPI.Interfaces.Registry.EntityEnum;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Interfaces.Registry.RegistrationList;
import Reika.DragonAPI.Interfaces.RetroactiveGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import Reika.DragonAPI.ModInteract.BannedItemReader;
import Reika.DragonAPI.ModInteract.DeepInteract.FrameBlacklist;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.SensitiveFluidRegistry;
import Reika.DragonAPI.ModInteract.DeepInteract.SensitiveItemRegistry;
import Reika.DragonAPI.ModInteract.DeepInteract.TimeTorchHelper;
import Reika.DragonAPI.ModInteract.ItemStackRepository;
import Reika.DragonAPI.ModInteract.ReikaEEHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Auxiliary.ClearSteamCommand;
import Reika.ReactorCraft.Auxiliary.IronFinderOverlay;
import Reika.ReactorCraft.Auxiliary.Lua.ReactorLuaMethods;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Auxiliary.PoisonGasDamage;
import Reika.ReactorCraft.Auxiliary.PotionRadiation;
import Reika.ReactorCraft.Auxiliary.RadiationDamage;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Auxiliary.RadiationFluidEffect;
import Reika.ReactorCraft.Auxiliary.ReactorBlock;
import Reika.ReactorCraft.Auxiliary.ReactorBookTracker;
import Reika.ReactorCraft.Auxiliary.ReactorDescriptions;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Auxiliary.ReactorTab;
import Reika.ReactorCraft.Base.TileEntityReactorPiping;
import Reika.ReactorCraft.Blocks.BlockTritiumLamp;
import Reika.ReactorCraft.CommonProxy;
import Reika.ReactorCraft.LiquidHandler;
import Reika.ReactorCraft.ReactorConfig;
import Reika.ReactorCraft.ReactorGuiHandler;
import Reika.ReactorCraft.ReactorPacketCore;
import Reika.ReactorCraft.ReactorRecipes;
import Reika.ReactorCraft.Registry.CraftingItems;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorEntities;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorOres;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamInjector;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.ReactorCraft.World.ReactorOreGenerator;
import Reika.RotaryCraft.API.BlockColorInterface;
import Reika.RotaryCraft.Auxiliary.LockNotification;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import net.bdew.gendustry.api.GendustryAPI;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;

@Mod(modid="ReactorCraft", name="ReactorCraft", version="v18b", certificateFingerprint="32:F5:F4:E8:44:C0:EA:C8:6F:46:8A:8E:F3:05:05:7B:6F:90:0F:78", dependencies="required-after:DragonAPI;required-after:RotaryCraft")
public class ReactorCraft
extends DragonAPIMod {
    @Mod.Instance(value="ReactorCraft")
    public static ReactorCraft instance = new ReactorCraft();
    public static final ReactorConfig config = new ReactorConfig(instance, (ConfigList[])ReactorOptions.optionList, null);
    public static final String packetChannel = "ReactorCraftData";
    public static ReactorTab tabRctr = new ReactorTab("ReactorCraft");
    public static ReactorTab tabRctrItems = new ReactorTab("ReactorCraft Items");
    public static ReactorTab tabRctrMultis = new ReactorTab("ReactorCraft Components");
    public static final ItemArmor.ArmorMaterial HAZ = EnumHelper.addArmorMaterial((String)"RCHazmat", (int)0, (int[])new int[]{0, 0, 0, 0}, (int)0);
    public static ModLogger logger;
    private boolean isLocked = false;
    public static Item[] items;
    public static Block[] blocks;
    public static final Fluid D2O;
    public static final Fluid HF;
    public static final Fluid UF6;
    public static final Fluid NH3;
    public static final Fluid NA;
    public static final Fluid CL;
    public static final Fluid O;
    public static final Fluid NH3_lo;
    public static final Fluid H2O_lo;
    public static final Fluid NA_hot;
    public static final Fluid H2;
    public static final Fluid H3;
    public static final Fluid CO2;
    public static final Fluid CO2_hot;
    public static final Fluid PLASMA;
    public static final Fluid CORIUM;
    public static final Fluid WASTE;
    public static final Fluid LI;
    public static final Fluid LIFBe;
    public static final Fluid LIFBe_fuel;
    public static final Fluid LIFBe_hot;
    public static PotionRadiation radiation;
    public static IIcon solarFlare;
    public static Achievement[] achievements;
    public static final RadiationDamage radiationDamage;
    public static final CustomStringDamageSource fusionDamage;
    public static final PoisonGasDamage gasDamage;
    @SidedProxy(clientSide="Reika.ReactorCraft.ClientProxy", serverSide="Reika.ReactorCraft.CommonProxy")
    public static CommonProxy proxy;

    public final boolean isLocked() {
        return this.isLocked || RotaryCraft.instance.isLocked();
    }

    private final boolean checkForLock() {
        Item id;
        Enum r;
        int i;
        for (i = 0; i < ReactorItems.itemList.length; ++i) {
            r = ReactorItems.itemList[i];
            if (((ReactorItems)r).isDummiedOut() || !BannedItemReader.instance.containsID(id = ((ReactorItems)r).getItemInstance())) continue;
            return true;
        }
        for (i = 0; i < ReactorBlocks.blockList.length; ++i) {
            r = ReactorBlocks.blockList[i];
            if (((ReactorBlocks)r).isDummiedOut() || !BannedItemReader.instance.containsID((Block)(id = ((ReactorBlocks)r).getBlockInstance()))) continue;
            return true;
        }
        return false;
    }

    protected HashMap<String, String> getDependencies() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("RotaryCraft", RotaryCraft.currentVersion);
        return map;
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent evt) {
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.PRELOAD);
        this.verifyInstallation();
        MinecraftForge.EVENT_BUS.register((Object)new LiquidHandler());
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)IronFinderOverlay.instance);
        }
        config.loadSubfolderedConfigFile(evt);
        config.initProps(evt);
        proxy.registerSounds();
        this.isLocked = this.checkForLock();
        if (this.isLocked()) {
            ReikaJavaLibrary.pConsole((Object)"");
            ReikaJavaLibrary.pConsole((Object)"\t========================================= REACTORCRAFT ===============================================");
            ReikaJavaLibrary.pConsole((Object)"\tNOTICE: It has been detected that third-party plugins are being used to disable parts of ReactorCraft.");
            ReikaJavaLibrary.pConsole((Object)"\tBecause this is frequently done to sell access to mod content, which is against the Terms of Use");
            ReikaJavaLibrary.pConsole((Object)"\tof both Mojang and the mod, the mod has been functionally disabled. No damage will occur to worlds,");
            ReikaJavaLibrary.pConsole((Object)"\tand all machines (including contents) and items already placed or in inventories will remain so,");
            ReikaJavaLibrary.pConsole((Object)"\tbut its machines will not function, recipes will not load, and no renders or textures will be present.");
            ReikaJavaLibrary.pConsole((Object)"\tAll other mods in your installation will remain fully functional.");
            ReikaJavaLibrary.pConsole((Object)"\tTo regain functionality, unban the ReactorCraft content, and then reload the game. All functionality");
            ReikaJavaLibrary.pConsole((Object)"\twill be restored. You may contact Reika for further information on his forum thread.");
            ReikaJavaLibrary.pConsole((Object)"\t=====================================================================================================");
            ReikaJavaLibrary.pConsole((Object)"");
        }
        logger = new ModLogger((DragonAPIMod)instance, false);
        if (DragonOptions.FILELOG.getState()) {
            logger.setOutput("**_Loading_Log.log");
        }
        this.addLiquids();
        this.addBlocks();
        this.addItems();
        this.addLiquidContainers();
        this.registerOres();
        ReactorTiles.loadMappings();
        ReactorItems.loadMappings();
        ReactorBlocks.loadMappings();
        CORIUM.setBlock(ReactorBlocks.CORIUMFLOWING.getBlockInstance());
        HF.setBlock(ReactorBlocks.HF.getBlockInstance());
        CL.setBlock(ReactorBlocks.CHLORINE.getBlockInstance());
        tabRctr.setIcon(ReactorTiles.MAGNET.getCraftedProduct());
        tabRctrItems.setIcon(ReactorItems.WASTE.getStackOf());
        tabRctrMultis.setIcon(ReactorBlocks.SOLENOIDMULTI.getStackOfMetadata(2));
        CreativeTabSorter.instance.registerCreativeTabAfter((CreativeTabs)tabRctr, RotaryCraft.tabRotary);
        CreativeTabSorter.instance.registerCreativeTabAfter((CreativeTabs)tabRctrMultis, (CreativeTabs)tabRctr);
        CreativeTabSorter.instance.registerCreativeTabAfter((CreativeTabs)tabRctrItems, (CreativeTabs)tabRctr);
        ReikaPacketHelper.registerPacketHandler((DragonAPIMod)instance, (String)packetChannel, (PacketHandler)new ReactorPacketCore());
        if (ConfigRegistry.ACHIEVEMENTS.getState()) {
            achievements = new Achievement[ReactorAchievements.list.length];
            ReactorAchievements.registerAchievements();
        }
        PotionCollisionTracker.instance.addPotionID((DragonAPIMod)instance, config.getRadiationPotionID(), PotionRadiation.class);
        radiation = (PotionRadiation)new PotionRadiation(config.getRadiationPotionID()).func_76390_b("Radiation Sickness");
        FMLInterModComms.sendMessage((String)"zzzzzcustomconfigs", (String)"blacklist-mod-as-output", (String)this.getModContainer().getModId());
        if (ModList.GENDUSTRY.isLoaded()) {
            try {
                GendustryAPI.Registries.getMutagenRegistry().add(ReactorItems.WASTE.getItemInstance(), 10000);
                GendustryAPI.Registries.getMutagenRegistry().add(ReactorItems.FUEL.getItemInstance(), 2000);
                GendustryAPI.Registries.getMutagenRegistry().add(ReactorItems.PLUTONIUM.getItemInstance(), 5000);
                GendustryAPI.Registries.getMutagenRegistry().add(ReactorItems.PELLET.getItemInstance(), 1200);
            }
            catch (IncompatibleClassChangeError e) {
                logger.logError((Object)("Could not add Gendustry integration. Check your versions; if you are up-to-date with both mods, notify Reika. " + e.toString()));
            }
            catch (Exception e) {
                logger.logError((Object)("Could not add Gendustry integration. Check your versions; if you are up-to-date with both mods, notify Reika. " + e.toString()));
            }
        }
        this.basicSetup(evt);
        this.finishTiming();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ItemStack is;
        int i;
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.LOAD);
        if (this.isLocked() && !RotaryCraft.instance.isLocked()) {
            PlayerHandler.instance.registerTracker((PlayerHandler.PlayerTracker)LockNotification.instance);
        }
        if (!this.isLocked()) {
            proxy.registerRenderers();
            ReactorRecipes.addRecipes();
        }
        this.addEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new ReactorGuiHandler());
        RetroGenController.instance.addHybridGenerator((RetroactiveGenerator)ReactorOreGenerator.instance, 0, ReactorOptions.RETROGEN.getState());
        ItemStackRepository.instance.registerClass((DragonAPIMod)this, ReactorStacks.class);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReactorDescriptions.loadData();
        }
        for (i = 0; i < MatBlocks.matList.length; ++i) {
            is = MatBlocks.matList[i].getStackOf();
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)is);
        }
        for (i = 0; i < FluoriteTypes.colorList.length; ++i) {
            is = FluoriteTypes.colorList[i].getStorageBlock();
            FMLInterModComms.sendMessage((String)"ForgeMicroblock", (String)"microMaterial", (ItemStack)is);
        }
        for (i = 0; i < FluoriteTypes.colorList.length; ++i) {
            FluoriteTypes f = FluoriteTypes.colorList[i];
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("value", f.getCorrespondingDyeType().getWoolMeta());
            f.getItem().func_77955_b(tag);
            FMLInterModComms.sendMessage((String)ModList.MINEFACTORY.modLabel, (String)"addLaserPreferredOre", (NBTTagCompound)tag);
        }
        FMLInterModComms.sendMessage((String)"Randomod", (String)"blacklist", (String)this.getModContainer().getModId());
        PackModificationTracker.instance.addMod((DragonAPIMod)this, (ControlledConfig)config);
        if (!this.isLocked()) {
            IntegrityChecker.instance.addMod((DragonAPIMod)instance, (BlockEnum[])ReactorBlocks.blockList, (ItemEnum[])ReactorItems.itemList);
        }
        VanillaIntegrityTracker.instance.addWatchedBlock((DragonAPIMod)instance, Blocks.field_150357_h);
        VanillaIntegrityTracker.instance.addWatchedBlock((DragonAPIMod)instance, Blocks.field_150340_R);
        VanillaIntegrityTracker.instance.addWatchedBlock((DragonAPIMod)instance, Blocks.field_150405_ch);
        if (ConfigRegistry.HANDBOOK.getState()) {
            PlayerFirstTimeTracker.addTracker((PlayerFirstTimeTracker.PlayerTracker)new ReactorBookTracker());
        }
        ReikaEEHelper.blacklistEntry((RegistrationList)ReactorItems.FUEL);
        ReikaEEHelper.blacklistEntry((RegistrationList)ReactorItems.BREEDERFUEL);
        ReikaEEHelper.blacklistEntry((RegistrationList)ReactorItems.PELLET);
        ReikaEEHelper.blacklistEntry((RegistrationList)ReactorItems.PLUTONIUM);
        SuggestedModsTracker.instance.addSuggestedMod((DragonAPIMod)instance, ModList.CHROMATICRAFT, "Dense pitchblende generation in its biomes");
        SuggestedModsTracker.instance.addSuggestedMod((DragonAPIMod)instance, ModList.TWILIGHT, "Dense pitchblende generation in its biomes");
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorItems.FUEL.getItemInstance(), true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorItems.BREEDERFUEL.getItemInstance(), true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorItems.PLUTONIUM.getItemInstance(), true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorItems.PELLET.getItemInstance(), true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorStacks.fueldust, true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, ReactorStacks.thordust, true);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, CraftingItems.ALLOY.getItem(), false);
        SensitiveItemRegistry.instance.registerItem((DragonAPIMod)this, CraftingItems.FERROINGOT.getItem(), false);
        SensitiveFluidRegistry.instance.registerFluid("rc fusion plasma");
        SensitiveFluidRegistry.instance.registerFluid("rc deuterium");
        SensitiveFluidRegistry.instance.registerFluid("rc tritium");
        SensitiveFluidRegistry.instance.registerFluid("rc hydrofluoric acid");
        SensitiveFluidRegistry.instance.registerFluid("rc uranium hexafluoride");
        SensitiveFluidRegistry.instance.registerFluid("rc sodium");
        SensitiveFluidRegistry.instance.registerFluid("rc chlorine");
        SensitiveFluidRegistry.instance.registerFluid("rc oxygen");
        SensitiveFluidRegistry.instance.registerFluid("rc lowpammonia");
        SensitiveFluidRegistry.instance.registerFluid("rc lowpwater");
        SensitiveFluidRegistry.instance.registerFluid("rc hotsodium");
        SensitiveFluidRegistry.instance.registerFluid("rc co2");
        SensitiveFluidRegistry.instance.registerFluid("rc hot co2");
        SensitiveFluidRegistry.instance.registerFluid("rc corium");
        SensitiveFluidRegistry.instance.registerFluid("rc lithium");
        SensitiveFluidRegistry.instance.registerFluid("rc lifbe");
        SensitiveFluidRegistry.instance.registerFluid("rc lifbe fuel");
        SensitiveFluidRegistry.instance.registerFluid("rc hot lifbe");
        this.finishTiming();
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent evt) {
        int i;
        this.startTiming(DragonAPIMod.LoadProfiler.LoadPhase.POSTLOAD);
        if (!this.isLocked()) {
            ReactorRecipes.addModInterface();
        }
        for (i = 0; i < ReactorTiles.TEList.length; ++i) {
            ReactorTiles r = ReactorTiles.TEList[i];
            BlockColorInterface.addGPRBlockColor((Block)r.getBlock(), (int)r.getBlockMetadata(), (int)200, (int)200, (int)200);
        }
        ReikaJavaLibrary.initClass(ReactorLuaMethods.class);
        proxy.loadDonatorRender();
        TileEntityReservoir.addFluidEffect((String)"rc nuclear waste", (TileEntityReservoir.FluidEffect)new RadiationFluidEffect());
        for (i = 0; i < ReactorTiles.TEList.length; ++i) {
            ReactorTiles m = ReactorTiles.TEList[i];
            if (m == ReactorTiles.PROCESSOR) continue;
            if (ModList.CHROMATICRAFT.isLoaded()) {
                AcceleratorBlacklist.addBlacklist((Class)m.getTEClass(), (String)m.getName(), (AcceleratorBlacklist.BlacklistReason)AcceleratorBlacklist.BlacklistReason.EXPLOIT);
            }
            TimeTorchHelper.blacklistTileEntity((Class)m.getTEClass());
        }
        if (ModList.CHROMATICRAFT.isLoaded()) {
            CrystalPotionInterface.addBadPotionForIgnore((Potion)radiation);
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            ItemStack drop;
            ItemStack block;
            for (i = 0; i < ReactorOres.oreList.length; ++i) {
                ReactorOres ore = ReactorOres.oreList[i];
                block = ore.getOreBlock();
                drop = ore.getProduct();
            }
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.CADMIUM.getOreBlock(), (Object[])new Object[]{Aspect.METAL, 1});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.INDIUM.getOreBlock(), (Object[])new Object[]{Aspect.METAL, 1, Aspect.GREED, 1});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.CALCITE.getOreBlock(), (Object[])new Object[]{Aspect.CRYSTAL, 1});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.MAGNETITE.getOreBlock(), (Object[])new Object[]{Aspect.METAL, 1, Aspect.CRYSTAL, 1, Aspect.AURA, 1});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.AMMONIUM.getOreBlock(), (Object[])new Object[]{Aspect.FIRE, 1});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.MAGNETITE.getProduct(), (Object[])new Object[]{Aspect.AURA, 2, Aspect.METAL, 2, Aspect.CRYSTAL, 2});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.CALCITE.getProduct(), (Object[])new Object[]{Aspect.CRYSTAL, 2});
            ReikaThaumHelper.addAspects((ItemStack)ReactorOres.AMMONIUM.getProduct(), (Object[])new Object[]{Aspect.FIRE, 2});
            for (i = 0; i < FluoriteTypes.colorList.length; ++i) {
                FluoriteTypes f = FluoriteTypes.colorList[i];
                block = f.getOreBlock();
                drop = f.getItem();
                ItemStack ore = f.getOreBlock();
                ReikaThaumHelper.addAspects((ItemStack)ore, (Object[])new Object[]{Aspect.CRYSTAL, 1});
                ReikaThaumHelper.addAspects((ItemStack)ore, (Object[])new Object[]{Aspect.SENSES, 1});
                ReikaThaumHelper.addAspects((ItemStack)block, (Object[])new Object[]{Aspect.CRYSTAL, 1});
                ReikaThaumHelper.addAspects((ItemStack)block, (Object[])new Object[]{Aspect.SENSES, 1});
                ReikaThaumHelper.addAspects((ItemStack)drop, (Object[])new Object[]{Aspect.CRYSTAL, 2});
            }
        }
        this.finishTiming();
    }

    @Mod.EventHandler
    public void registerCommands(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new ClearSteamCommand());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        if (!this.isLocked()) {
            ReactorCraft.setupLiquidIcons(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setupLiquidIcons(TextureStitchEvent.Pre event) {
        logger.log((Object)"Loading Liquid Icons");
        if (event.map.func_130086_a() == 0) {
            IIcon d2o = event.map.func_94245_a("ReactorCraft:fluid/heavywater");
            IIcon hf = event.map.func_94245_a("ReactorCraft:fluid/hf");
            IIcon uf6 = event.map.func_94245_a("ReactorCraft:fluid/uf6");
            IIcon nh3 = event.map.func_94245_a("ReactorCraft:fluid/ammonia");
            IIcon na = event.map.func_94245_a("ReactorCraft:fluid/sodium");
            IIcon nahot = event.map.func_94245_a("ReactorCraft:fluid/sodiumhot");
            IIcon cl = event.map.func_94245_a("ReactorCraft:fluid/chlorine");
            IIcon o = event.map.func_94245_a("ReactorCraft:fluid/oxygen");
            IIcon h2 = event.map.func_94245_a("ReactorCraft:fluid/deuterium");
            IIcon h3 = event.map.func_94245_a("ReactorCraft:fluid/tritium");
            IIcon plasma = event.map.func_94245_a("ReactorCraft:fluid/plasma");
            IIcon co2 = event.map.func_94245_a("ReactorCraft:fluid/co2");
            IIcon corium = event.map.func_94245_a("ReactorCraft:fluid/slag_flow");
            IIcon corium2 = event.map.func_94245_a("ReactorCraft:fluid/slag_flow");
            IIcon li = event.map.func_94245_a("ReactorCraft:fluid/lithium");
            IIcon lifbe = event.map.func_94245_a("ReactorCraft:fluid/lifbe");
            IIcon lifbe_fuel = event.map.func_94245_a("ReactorCraft:fluid/lifbe_fuel");
            IIcon lifbe_hot = event.map.func_94245_a("ReactorCraft:fluid/lifbe_hot");
            D2O.setIcons(d2o);
            HF.setIcons(hf);
            UF6.setIcons(uf6);
            NH3.setIcons(nh3);
            NA.setIcons(na);
            CL.setIcons(cl);
            O.setIcons(o);
            H2.setIcons(h2);
            H3.setIcons(h3);
            PLASMA.setIcons(plasma);
            NH3_lo.setIcons(nh3);
            H2O_lo.setIcons(Blocks.field_150355_j.func_149691_a(1, 0));
            NA_hot.setIcons(nahot);
            CO2.setIcons(co2);
            CO2_hot.setIcons(co2);
            CORIUM.setIcons(corium, corium2);
            WASTE.setIcons(corium, corium2);
            LI.setIcons(li);
            LIFBe.setIcons(lifbe);
            LIFBe_fuel.setIcons(lifbe_fuel);
            LIFBe_hot.setIcons(lifbe_hot);
            solarFlare = event.map.func_94245_a("ReactorCraft:solarflare");
        }
    }

    private static void addItems() {
        ReikaRegistryHelper.instantiateAndRegisterItems((DragonAPIMod)instance, (ItemEnum[])ReactorItems.itemList, (Item[])items);
    }

    private static void addEntities() {
        ReikaRegistryHelper.registerModEntities((Object)((Object)instance), (EntityEnum[])ReactorEntities.entityList);
    }

    private static void addBlocks() {
        ReikaRegistryHelper.instantiateAndRegisterBlocks((DragonAPIMod)instance, (BlockEnum[])ReactorBlocks.blockList, (Block[])blocks);
        for (int i = 0; i < ReactorTiles.TEList.length; ++i) {
            GameRegistry.registerTileEntity((Class)ReactorTiles.TEList[i].getTEClass(), (String)("Reactor" + ReactorTiles.TEList[i].getName()));
            ReikaJavaLibrary.initClass((Class)ReactorTiles.TEList[i].getTEClass());
        }
        GameRegistry.registerTileEntity(TileEntitySteamInjector.class, (String)"ReactorSteamInjector");
        GameRegistry.registerTileEntity(BlockTritiumLamp.TileEntityTritiumLamp.class, (String)"ReactorTritiumLamp");
    }

    private static void addLiquids() {
        logger.log((Object)"Loading And Registering Liquids");
        FluidRegistry.registerFluid((Fluid)D2O);
        FluidRegistry.registerFluid((Fluid)HF);
        FluidRegistry.registerFluid((Fluid)UF6);
        FluidRegistry.registerFluid((Fluid)NH3);
        FluidRegistry.registerFluid((Fluid)NA);
        FluidRegistry.registerFluid((Fluid)CL);
        FluidRegistry.registerFluid((Fluid)O);
        FluidRegistry.registerFluid((Fluid)H2);
        FluidRegistry.registerFluid((Fluid)H3);
        FluidRegistry.registerFluid((Fluid)PLASMA);
        FluidRegistry.registerFluid((Fluid)NH3_lo);
        FluidRegistry.registerFluid((Fluid)H2O_lo);
        FluidRegistry.registerFluid((Fluid)NA_hot);
        FluidRegistry.registerFluid((Fluid)CO2);
        FluidRegistry.registerFluid((Fluid)CO2_hot);
        FluidRegistry.registerFluid((Fluid)CORIUM);
        FluidRegistry.registerFluid((Fluid)WASTE);
        FluidRegistry.registerFluid((Fluid)LI);
        FluidRegistry.registerFluid((Fluid)LIFBe);
        FluidRegistry.registerFluid((Fluid)LIFBe_hot);
        FluidRegistry.registerFluid((Fluid)LIFBe_fuel);
    }

    private static void addLiquidContainers() {
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(D2O, 1000), (ItemStack)ReactorItems.BUCKET.getStackOfMetadata(0), (ItemStack)new ItemStack(Items.field_151133_ar));
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(HF, 1000), (ItemStack)ReactorStacks.hfcan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(UF6, 1000), (ItemStack)ReactorStacks.uf6can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(NH3, 1000), (ItemStack)ReactorStacks.nh3can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(NA, 1000), (ItemStack)ReactorStacks.nacan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(CL, 1000), (ItemStack)ReactorStacks.clcan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(O, 1000), (ItemStack)ReactorStacks.ocan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(H2, 1000), (ItemStack)ReactorStacks.h2can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(H3, 1000), (ItemStack)ReactorStacks.h3can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(CO2, 1000), (ItemStack)ReactorStacks.co2can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(CO2_hot, 1000), (ItemStack)ReactorStacks.hotco2can, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(NA_hot, 1000), (ItemStack)ReactorStacks.hotnacan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(LI, 1000), (ItemStack)ReactorStacks.lican, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(LIFBe, 1000), (ItemStack)ReactorStacks.lifbecan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(LIFBe_hot, 1000), (ItemStack)ReactorStacks.hotlifbecan, (ItemStack)ReactorStacks.emptycan);
        FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(LIFBe_fuel, 1000), (ItemStack)ReactorStacks.lifbefuelcan, (ItemStack)ReactorStacks.emptycan);
    }

    public static final boolean hasGui(World world, int x, int y, int z, EntityPlayer ep) {
        Object GUI;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (GUI = ReactorGuiHandler.instance.getClientGuiElement(0, ep, world, x, y, z)) != null) {
            return true;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (GUI = ReactorGuiHandler.instance.getServerGuiElement(0, ep, world, x, y, z)) != null;
    }

    private static void registerOres() {
        for (int i = 0; i < ReactorOres.oreList.length; ++i) {
            ReactorOres ore = ReactorOres.oreList[i];
            if (ore == ReactorOres.FLUORITE) continue;
            OreDictionary.registerOre((String)ore.getDictionaryName(), (ItemStack)ore.getOreBlock());
            OreDictionary.registerOre((String)ore.getProductDictionaryName(), (ItemStack)ore.getProduct());
        }
        ((EnumOreBlock)ReactorBlocks.ORE.getBlockInstance()).register();
        Block b = ReactorBlocks.FLUORITEORE.getBlockInstance();
        b.setHarvestLevel("pickaxe", ReactorOres.FLUORITE.harvestLevel);
        OreDictionary.registerOre((String)"dustQuicklime", (ItemStack)ReactorStacks.lime.func_77946_l());
        for (int i = 0; i < FluoriteTypes.colorList.length; ++i) {
            FluoriteTypes fl = FluoriteTypes.colorList[i];
            ItemStack is = new ItemStack(ReactorBlocks.FLUORITEORE.getBlockInstance(), 1, i);
            OreDictionary.registerOre((String)ReactorOres.FLUORITE.getDictionaryName(), (ItemStack)is);
            OreDictionary.registerOre((String)ReactorOres.FLUORITE.getProductDictionaryName(), (ItemStack)fl.getItem());
        }
    }

    @SubscribeEvent
    public void cancelFramez(FrameBlacklist.FrameUsageEvent evt) {
        if (!this.isMovable(evt.tile)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @DependentMethodStripper.ModDependent(value=ModList.BLOODMAGIC)
    @DependentMethodStripper.ClassDependent(value="WayofTime.alchemicalWizardry.api.event.TeleposeEvent")
    public void noTelepose(TeleposeEvent evt) {
        if (!this.isMovable(evt.getInitialTile()) || !this.isMovable(evt.getFinalTile())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    @DependentMethodStripper.ModDependent(value=ModList.IC2)
    public void radiationProtection(LivingHurtEvent evt) {
        if (evt.source.field_76373_n.contains("radiation") && RadiationEffects.instance.hasHazmatSuit(evt.entityLiving)) {
            evt.setCanceled(true);
        }
    }

    private boolean isMovable(TileEntity te) {
        if (te instanceof ReactorBlock) {
            return false;
        }
        if (te instanceof MultiBlockTile) {
            return false;
        }
        if (te instanceof TileEntityReactorPiping) {
            return false;
        }
        return !(te instanceof TileEntitySteamLine);
    }

    public String getDisplayName() {
        return "ReactorCraft";
    }

    public String getModAuthorName() {
        return "Reika";
    }

    public URL getDocumentationSite() {
        return DragonAPICore.getReikaForumPage();
    }

    public String getUpdateCheckURL() {
        return "http://server.techjargaming.com/Reika/versions";
    }

    public String getWiki() {
        return RotaryCraft.instance.getWiki();
    }

    public ModLogger getModLogger() {
        return logger;
    }

    public File getConfigFolder() {
        return config.getConfigFolder();
    }

    static {
        items = new Item[ReactorItems.itemList.length];
        blocks = new Block[ReactorBlocks.blockList.length];
        D2O = new Fluid("rc heavy water").setDensity(1100).setViscosity(1050);
        HF = new Fluid("rc hydrofluoric acid").setDensity(115).setViscosity(10).setGaseous(true);
        UF6 = new Fluid("rc uranium hexafluoride").setDensity(15).setViscosity(10).setGaseous(true);
        NH3 = new Fluid("rc ammonia").setDensity(682).setViscosity(600);
        NA = new Fluid("rc sodium").setDensity(927).setViscosity(700).setTemperature(1100);
        CL = new Fluid("rc chlorine").setDensity(320).setViscosity(12).setGaseous(true);
        O = new Fluid("rc oxygen").setDensity(138).setViscosity(20).setGaseous(true);
        NH3_lo = new Fluid("rc lowpammonia").setDensity(200).setViscosity(600);
        H2O_lo = new Fluid("rc lowpwater").setDensity(800).setViscosity(800);
        NA_hot = new Fluid("rc hotsodium").setDensity(720).setViscosity(650).setTemperature(2000).setLuminosity(8);
        H2 = new Fluid("rc deuterium").setDensity(-1).setViscosity(10).setGaseous(true);
        H3 = new Fluid("rc tritium").setDensity(-1).setViscosity(10).setGaseous(true);
        CO2 = new Fluid("rc co2").setDensity(2).setViscosity(7).setGaseous(true);
        CO2_hot = new Fluid("rc hot co2").setDensity(1).setViscosity(5).setGaseous(true).setLuminosity(2);
        PLASMA = new Fluid("rc fusion plasma").setDensity(-1).setViscosity(100).setGaseous(true).setTemperature(150000000).setLuminosity(15);
        CORIUM = new Fluid("rc corium").setDensity(5000).setViscosity(8000).setTemperature(2173);
        WASTE = new Fluid("rc nuclear waste").setDensity(4000).setViscosity(12000).setTemperature(800);
        LI = new Fluid("rc lithium").setDensity(516).setViscosity(645).setTemperature(454).setLuminosity(6);
        LIFBe = new Fluid("rc lifbe").setDensity(6300).setViscosity(2400).setTemperature(773);
        LIFBe_fuel = new Fluid("rc lifbe fuel").setDensity(6750).setViscosity(2550).setTemperature(773);
        LIFBe_hot = new Fluid("rc hot lifbe").setDensity(6000).setViscosity(2400).setTemperature(1273).setLuminosity(8);
        radiationDamage = new RadiationDamage();
        fusionDamage = new CustomStringDamageSource("jumped in a Fusion Reactor");
        gasDamage = new PoisonGasDamage();
    }
}

