/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Base.TileEntityTankedReactorMachine;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileEntityNuclearBoiler
extends TileEntityTankedReactorMachine
implements ReactorCoreTE {
    protected int steam;
    protected ReactorType type;

    public final void setReactorType(ReactorType t) {
        this.type = t;
    }

    public final ReactorType getReactorType() {
        return this.type;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap() && !world.field_72995_K) {
            this.updateTemperature(world, x, y, z);
        }
        this.balanceFluid(world, x, y, z);
    }

    @Override
    protected final void updateTemperature(World world, int x, int y, int z) {
        super.updateTemperature(world, x, y, z);
        if (this.temperature > this.getMaxTemperature()) {
            this.overheat(world, x, y, z);
        }
    }

    protected abstract void overheat(World var1, int var2, int var3, int var4);

    @Override
    public final int getTemperature() {
        return this.temperature;
    }

    @Override
    public final void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public final boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public final boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }

    protected void balanceFluid(World world, int x, int y, int z) {
        for (int i = 0; i < 2; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (r != ReactorTiles.TEList[this.getIndex()]) continue;
            TileEntityNuclearBoiler te = (TileEntityNuclearBoiler)world.func_147438_o(dx, dy, dz);
            if (te.tank.getLevel() >= this.tank.getLevel() || !te.tank.isEmpty() && te.tank.getActualFluid() != this.tank.getActualFluid()) continue;
            int dl = this.tank.getLevel() - te.tank.getLevel();
            te.tank.addLiquid(dl / 4 + 1, this.tank.getActualFluid());
            this.tank.removeLiquid(dl / 4 + 1);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.FLUID && with == ForgeDirection.DOWN ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public final void addLiquid(int amt, Fluid fluid) {
        this.tank.addLiquid(amt, fluid);
    }

    @Override
    public final int getTextureState(ForgeDirection side) {
        if (side.offsetY != 0) {
            return 0;
        }
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles src = this.getMachine();
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        ReactorTiles r2 = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r2 == src && r == src) {
            return 2;
        }
        if (r2 == src) {
            return 1;
        }
        if (r == src) {
            return 3;
        }
        return 0;
    }

    public final int removeSteam() {
        int s = this.steam;
        this.steam = 0;
        return s;
    }
}

