/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.ReactorCraft.Registry.ReactorItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class WasteManager {
    private static final ArrayList<Isotopes> wastes = new ArrayList();
    private static final WeightedRandom<Isotopes> yields = new WeightedRandom();
    private static final WeightedRandom<Isotopes> thoriumYields = new WeightedRandom();
    private static final Random rand = new Random();

    private static void addWaste(Isotopes iso, double percent) {
        wastes.add(iso);
        yields.addEntry((Object)iso, percent);
    }

    private static void addThoriumWaste(Isotopes iso, double percent) {
        wastes.add(iso);
        thoriumYields.addEntry((Object)iso, percent);
    }

    public static Isotopes getRandomWaste() {
        return (Isotopes)yields.getRandomEntry();
    }

    public static Isotopes getRandomThoriumWaste() {
        return (Isotopes)thoriumYields.getRandomEntry();
    }

    public static int getFullyRandomWaste() {
        int i = rand.nextInt(wastes.size());
        return i;
    }

    public static int getNumberWastes() {
        return wastes.size();
    }

    public static List<Isotopes> getWasteList() {
        return Collections.unmodifiableList(wastes);
    }

    public static ItemStack getRandomWasteItem() {
        Isotopes atom = WasteManager.getRandomWaste();
        ItemStack is = WasteManager.getWaste(atom);
        return is;
    }

    public static ItemStack getRandomThoriumWasteItem() {
        Isotopes atom = WasteManager.getRandomThoriumWaste();
        ItemStack is = WasteManager.getWaste(atom);
        return is;
    }

    public static ItemStack getWaste(Isotopes atom) {
        return ReactorItems.WASTE.getStackOfMetadata(wastes.indexOf(atom));
    }

    public static ItemStack getFullyRandomWasteItem() {
        int i = WasteManager.getFullyRandomWaste();
        Isotopes atom = wastes.get(i);
        ItemStack is = ReactorItems.WASTE.getStackOfMetadata(i);
        return is;
    }

    public static ChancedOutputList getOutputs() {
        ChancedOutputList c = new ChancedOutputList(false);
        for (Isotopes i : wastes) {
            float ch = (float)(100.0 * yields.getWeight((Object)i) / yields.getMaxWeight());
            if (!(ch > 0.0f)) continue;
            c.addItem(WasteManager.getWaste(i), ch);
        }
        return c;
    }

    public static ChancedOutputList getThoriumOutputs() {
        ChancedOutputList c = new ChancedOutputList(false);
        for (Isotopes i : wastes) {
            float ch = (float)(100.0 * thoriumYields.getWeight((Object)i) / thoriumYields.getMaxWeight());
            if (!(ch > 0.0f)) continue;
            c.addItem(WasteManager.getWaste(i), ch);
        }
        return c;
    }

    static {
        WasteManager.addWaste(Isotopes.Cs134, 6.79);
        WasteManager.addWaste(Isotopes.Xe135, 6.33);
        WasteManager.addWaste(Isotopes.Zr93, 6.3);
        WasteManager.addWaste(Isotopes.Mo99, 6.1);
        WasteManager.addWaste(Isotopes.Cs137, 6.09);
        WasteManager.addWaste(Isotopes.Tc99, 6.05);
        WasteManager.addWaste(Isotopes.Sr90, 5.75);
        WasteManager.addWaste(Isotopes.I131, 2.83);
        WasteManager.addWaste(Isotopes.Pm147, 2.27);
        WasteManager.addWaste(Isotopes.I129, 0.66);
        WasteManager.addWaste(Isotopes.Sm151, 0.42);
        WasteManager.addWaste(Isotopes.Ru106, 0.39);
        WasteManager.addWaste(Isotopes.Kr85, 0.27);
        WasteManager.addWaste(Isotopes.Pd107, 0.16);
        WasteManager.addWaste(Isotopes.Se79, 0.05);
        WasteManager.addWaste(Isotopes.Gd155, 0.03);
        WasteManager.addWaste(Isotopes.Sb125, 0.03);
        WasteManager.addWaste(Isotopes.Sn126, 0.02);
        WasteManager.addThoriumWaste(Isotopes.Cs137, 6.84);
        WasteManager.addThoriumWaste(Isotopes.I135, 5.03);
        WasteManager.addThoriumWaste(Isotopes.Tc99, 4.92);
        WasteManager.addThoriumWaste(Isotopes.Xe131, 3.6);
        WasteManager.addThoriumWaste(Isotopes.Pm147, 1.74);
        WasteManager.addThoriumWaste(Isotopes.Ru103, 1.57);
        WasteManager.addThoriumWaste(Isotopes.Xe135, 1.23);
        WasteManager.addThoriumWaste(Isotopes.Pm149, 0.78);
        WasteManager.addThoriumWaste(Isotopes.Rh105, 0.5);
        WasteManager.addThoriumWaste(Isotopes.Sm151, 0.32);
        WasteManager.addThoriumWaste(Isotopes.Ru106, 0.25);
    }
}

