/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Event.CreeperExplodeEvent;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.RadiationShield;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class RadiationEffects {
    private static final Random rand = new Random();
    public static final RadiationEffects instance = new RadiationEffects();

    private RadiationEffects() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void dirtyBombs(CreeperExplodeEvent evt) {
        if (evt.creeper.getEntityData().func_74767_n("radioactive")) {
            World world = evt.creeper.field_70170_p;
            int x = MathHelper.func_76128_c((double)evt.creeper.field_70165_t);
            int y = MathHelper.func_76128_c((double)evt.creeper.field_70163_u);
            int z = MathHelper.func_76128_c((double)evt.creeper.field_70161_v);
            this.contaminateArea(world, x, y, z, 4, 3.0f, 1.5, true, RadiationIntensity.MODERATE);
        }
    }

    public boolean applyEffects(EntityLivingBase e, RadiationIntensity ri) {
        if (ri.causesHarm()) {
            if (!(e.func_70644_a((Potion)ReactorCraft.radiation) || this.isEntityImmuneToAll(e) || ri.isShieldable() && this.hasHazmatSuit(e))) {
                e.func_70690_d(this.getRadiationEffect(ri));
                return true;
            }
            if (ReikaEntityHelper.isEntityWearingPoweredArmor((EntityLivingBase)e)) {
                for (int i = 1; i <= 4; ++i) {
                    ReikaItemHelper.dechargeItem((ItemStack)e.func_71124_b(i));
                }
            }
            if (e instanceof EntityCreeper) {
                EntityCreeper ec = (EntityCreeper)e;
                ec.getEntityData().func_74757_a("radioactive", true);
            }
        }
        return false;
    }

    public void applyPulseEffects(EntityLivingBase e, RadiationIntensity ri) {
        if (!(e.func_70644_a((Potion)ReactorCraft.radiation) || this.isEntityImmuneToAll(e) || this.hasHazmatSuit(e))) {
            e.func_70690_d(this.getRadiationEffect(20, ri));
        }
    }

    public boolean isEntityImmuneToAll(EntityLivingBase e) {
        return e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d;
    }

    public boolean hasHazmatSuit(EntityLivingBase e) {
        for (int i = 1; i < 5; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is == null) {
                return false;
            }
            ReactorItems ri = ReactorItems.getEntry(is);
            if (ri == null) {
                return false;
            }
            if (ri.isHazmat()) continue;
            return false;
        }
        return true;
    }

    public double contaminateArea(World world, int x, int y, int z, int range, float density, double force, boolean los, RadiationIntensity ri) {
        double frac = 1.0;
        int num = Math.max(1, (int)(Math.sqrt(range) * (double)density));
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)range, (double)range, (double)range);
        for (int i = 0; i < num; ++i) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)range);
            int dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)range);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)range);
            while (los && !this.isValidRadiationPosition(world, x, y, z, dx, dy, dz, 2.0)) {
                dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)range);
                dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)range);
                dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)range);
            }
            if (ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z)) <= force) {
                frac -= 1.0 / (double)num;
            }
            EntityRadiation rad = new EntityRadiation(world, range, ri);
            rad.func_70012_b((double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5, 0.0f, 0.0f);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)rad);
        }
        return frac;
    }

    private boolean isValidRadiationPosition(World world, int x, int y, int z, int dx, int dy, int dz, double forceDist) {
        if (ReikaMathLibrary.py3d((double)(dx - x), (double)(dy - y), (double)(dz - z)) <= forceDist) {
            return true;
        }
        ArrayList li = ReikaWorldHelper.getBlocksAlongVector((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)((double)dx + 0.5), (double)((double)dy + 0.5), (double)((double)dz + 0.5));
        double chance = 1.0;
        for (BlockKey bk : li) {
            RadiationShield rs = RadiationShield.getFrom(bk.blockID, bk.metadata);
            if (rs == null) continue;
            chance *= 1.0 - rs.radiationDeflectChance / 100.0;
        }
        boolean flag = chance > 0.0 && ReikaRandomHelper.doWithChance((double)chance);
        return flag;
    }

    public void transformBlock(World world, int x, int y, int z, RadiationIntensity ri) {
        if (world.field_72995_K) {
            return;
        }
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == Blocks.field_150350_a) {
            return;
        }
        if (id == Blocks.field_150330_I) {
            return;
        }
        if (ri.isAtLeast(RadiationIntensity.HIGHLEVEL)) {
            if (id == Blocks.field_150362_t || id == Blocks.field_150361_u || id.func_149688_o() == Material.field_151584_j || ModWoodList.isModLeaf((Block)id, (int)meta)) {
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150436_aH) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150329_H) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
            }
            if (id == Blocks.field_150395_bd) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150392_bi) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150328_O) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150327_N) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150464_aj) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150459_bM) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150469_bN) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150434_aF || id.func_149688_o() == Material.field_151570_A) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150423_aK) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150393_bb) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150440_ba) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150394_bc) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150345_g || id.func_149688_o() == Material.field_151585_k) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
            }
            if (id == Blocks.field_150375_by) {
                id.func_149697_b(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
            }
            if (id == Blocks.field_150341_Y) {
                world.func_147449_b(x, y, z, Blocks.field_150347_e);
            }
            if (id == Blocks.field_150349_c || id.func_149688_o() == Material.field_151577_b) {
                world.func_147449_b(x, y, z, Blocks.field_150346_d);
            }
            if (id == Blocks.field_150418_aU) {
                world.func_147465_d(x, y, z, ReikaBlockHelper.getSilverfishImitatedBlock((int)meta), 0, 3);
            }
        }
        if (id == ReactorBlocks.FLUORITE.getBlockInstance() || id == ReactorBlocks.FLUORITEORE.getBlockInstance()) {
            world.func_147465_d(x, y, z, id, meta + 8, 3);
            world.func_147479_m(x, y, z);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (ri.isAtLeast(RadiationIntensity.MODERATE) && ModList.THAUMCRAFT.isLoaded() && te instanceof INode) {
            INode n = (INode)te;
            n.addToContainer(Aspect.POISON, 10);
            n.addToContainer(Aspect.DEATH, 5);
            n.addToContainer(Aspect.ENTROPY, 10);
            n.addToContainer(Aspect.AURA, 5);
            n.addToContainer(Aspect.TAINT, 5);
            n.addToContainer(Aspect.ENERGY, 2);
            if (rand.nextInt(4) == 0) {
                if (n.getNodeType() == NodeType.NORMAL) {
                    n.setNodeType(NodeType.UNSTABLE);
                } else if (n.getNodeType() == NodeType.UNSTABLE) {
                    n.setNodeType(NodeType.TAINTED);
                }
            }
            if (rand.nextInt(8) == 0) {
                n.setNodeModifier(NodeModifier.BRIGHT);
            }
        }
    }

    public PotionEffect getRadiationEffect(RadiationIntensity ri) {
        return this.getRadiationEffect(ri.potionDuration, ri);
    }

    private PotionEffect getRadiationEffect(int duration, RadiationIntensity ri) {
        PotionEffect pot = new PotionEffect(ReactorCraft.radiation.field_76415_H, duration, ri.ordinal());
        pot.setCurativeItems(new ArrayList());
        return pot;
    }

    public static enum RadiationIntensity {
        BACKGROUND(0),
        LOWLEVEL(100),
        MODERATE(1200),
        HIGHLEVEL(6000),
        LETHAL(36000);

        public static final RadiationIntensity[] radiationList;
        private final int potionDuration;

        private RadiationIntensity(int t) {
            this.potionDuration = t;
        }

        public boolean isShieldable() {
            return this.ordinal() <= HIGHLEVEL.ordinal();
        }

        public boolean causesHarm() {
            return this != BACKGROUND;
        }

        public boolean isAtLeast(RadiationIntensity ri) {
            return this.ordinal() >= ri.ordinal();
        }

        static {
            radiationList = RadiationIntensity.values();
        }
    }
}

