/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.lib.gui;

import java.util.ArrayList;
import java.util.List;
import me.planetguy.lib.gui.GuiTabbed;
import me.planetguy.lib.gui.Tab;
import org.lwjgl.opengl.GL11;

public class TabGroup {
    public final GuiTabbed gui;
    public final boolean leftSide;
    private final List<Tab> tabs = new ArrayList<Tab>();

    public TabGroup(GuiTabbed gui) {
        this.gui = gui;
        this.leftSide = true;
    }

    public TabGroup(GuiTabbed gui, boolean leftSide) {
        this.gui = gui;
        this.leftSide = leftSide;
    }

    public void addTab(Tab tab) {
        tab.index = this.tabs.size();
        tab.group = this;
        this.tabs.add(tab);
    }

    public Tab getTab(int index) {
        return this.tabs.get(index);
    }

    public Tab getTabAt(int mouseX, int mouseY) {
        int tabIndex;
        if (mouseX > this.gui.guiLeft() - 28 && mouseX < this.gui.guiLeft() && mouseY > this.gui.guiTop() && (tabIndex = (mouseY - this.gui.guiTop()) / 29) < this.tabs.size()) {
            return this.tabs.get(tabIndex);
        }
        return null;
    }

    public void drawBackground() {
        for (Tab tab : this.tabs) {
            tab.drawBackground();
        }
    }

    public void drawForeground() {
        this.gui.itemRenderer().field_77023_b += 100.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        for (Tab tab : this.tabs) {
            tab.drawForeground();
        }
        GL11.glDisable((int)2896);
        this.gui.itemRenderer().field_77023_b -= 100.0f;
    }

    public boolean mouseClick(int mouseX, int mouseY) {
        Tab tab = this.getTabAt(mouseX, mouseY);
        if (tab != null) {
            return tab.mouseClick(mouseX, mouseY);
        }
        return false;
    }
}

