/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToEntity;
import am2.playerextensions.ExtendedProperties;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ManaDrain
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        double manaStolen = 250.0;
        ExtendedProperties targetProperties = ExtendedProperties.For((EntityLivingBase)target);
        if (manaStolen > (double)targetProperties.getCurrentMana()) {
            manaStolen = targetProperties.getCurrentMana();
        }
        targetProperties.setCurrentMana((float)((double)targetProperties.getCurrentMana() - manaStolen));
        targetProperties.forceSync();
        ExtendedProperties casterProperties = ExtendedProperties.For(caster);
        casterProperties.setCurrentMana((float)((double)casterProperties.getCurrentMana() + manaStolen));
        casterProperties.forceSync();
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 20.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 15; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.setIgnoreMaxAge(true);
            particle.AddParticleController(new ParticleArcToEntity(particle, 1, (Entity)caster, false).SetSpeed(0.03f).generateControlPoints());
            particle.setRGBColorF(0.0f, 0.4f, 1.0f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ARCANE);
    }

    @Override
    public int getID() {
        return 36;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 7);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 0);
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

