/*
 * Decompiled with CFR 0.152.
 */
package am2.damage;

import am2.damage.DamageSourceDarkNexus;
import am2.damage.DamageSourceFire;
import am2.damage.DamageSourceFrost;
import am2.damage.DamageSourceHoly;
import am2.damage.DamageSourceLightning;
import am2.damage.DamageSourceUnsummon;
import am2.damage.DamageSourceWTFBoom;
import am2.damage.DamageSourceWind;
import cpw.mods.fml.relauncher.ReflectionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class DamageSources {
    public static DamageSourceUnsummon unsummon = new DamageSourceUnsummon();
    public static DamageSourceWTFBoom wtfBoom = new DamageSourceWTFBoom();
    public static DamageSourceDarkNexus darkNexus = new DamageSourceDarkNexus();

    public static DamageSourceFire causeEntityFireDamage(EntityLivingBase source) {
        DamageSourceFire fire = new DamageSourceFire(source);
        fire.func_76351_m();
        return fire;
    }

    public static DamageSourceFrost causeEntityFrostDamage(EntityLivingBase source) {
        DamageSourceFrost frost = new DamageSourceFrost(source);
        frost.func_76351_m();
        return frost;
    }

    public static DamageSourceLightning causeEntityLightningDamage(EntityLivingBase source) {
        DamageSourceLightning lightning = new DamageSourceLightning(source);
        lightning.func_76351_m();
        return lightning;
    }

    public static DamageSourceWind causeEntityWindDamage(EntityLivingBase source) {
        DamageSourceWind wind = new DamageSourceWind(source);
        wind.func_76351_m();
        return wind;
    }

    public static DamageSourceHoly causeEntityHolyDamage(EntityLivingBase source) {
        DamageSourceHoly holy = new DamageSourceHoly(source);
        holy.func_76351_m();
        return holy;
    }

    public static DamageSource causeDamage(DamageSourceTypes type, EntityLivingBase source) {
        switch (type) {
            case FIRE: {
                DamageSourceFire fire = new DamageSourceFire(source);
                fire.func_76351_m();
                return fire;
            }
            case FROST: {
                DamageSourceFrost frost = new DamageSourceFrost(source);
                frost.func_76351_m();
                return frost;
            }
            case LIGHTNING: {
                DamageSourceLightning lightning = new DamageSourceLightning(source);
                lightning.func_76351_m();
                return lightning;
            }
            case MAGIC: {
                return DamageSource.func_76354_b((Entity)source, (Entity)source);
            }
            case WITHER: {
                return DamageSources.causeEntityWitherDamage(source);
            }
            case THORNS: {
                return DamageSources.causeEntityThornsDamage(source);
            }
            case CACTUS: {
                return DamageSources.causeEntityCactusDamage(source);
            }
        }
        return DamageSource.func_76358_a((EntityLivingBase)source);
    }

    public static DamageSource causeDamage(DamageSourceTypes type, EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeDamage(type, source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeEntityWitherDamage(EntityLivingBase source) {
        return new EntityDamageSource("wither", (Entity)source);
    }

    public static DamageSource causeEntityThornsDamage(EntityLivingBase source) {
        return new EntityDamageSource("thorns", (Entity)source);
    }

    public static DamageSource causeEntityCactusDamage(EntityLivingBase source) {
        return new EntityDamageSource("cactus", (Entity)source);
    }

    public static DamageSource causeEntityMagicDamage(EntityLivingBase source) {
        EntityDamageSource ds = new EntityDamageSource("magic", (Entity)source);
        ds.func_82726_p();
        DamageSources.setDamageSourceUnblockable((DamageSource)ds);
        return ds;
    }

    public static DamageSource causeEntityPhysicalDamage(Entity source) {
        if (source instanceof EntityPlayer) {
            return new EntityDamageSource("player", source);
        }
        return new EntityDamageSource("mob", source);
    }

    public static DamageSource causeEntityWitherDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeEntityWitherDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeEntityThornsDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeEntityThornsDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource causeEntityCactusDamage(EntityLivingBase source, boolean unblockable) {
        DamageSource ds = DamageSources.causeEntityCactusDamage(source);
        if (unblockable) {
            DamageSources.setDamageSourceUnblockable(ds);
        }
        return ds;
    }

    public static DamageSource setDamageSourceUnblockable(DamageSource original) {
        ReflectionHelper.setPrivateValue(DamageSource.class, (Object)original, (Object)true, (String[])new String[]{"field_76374_o", "isUnblockable"});
        return original;
    }

    public static DamageSource causeEntityDrownDamage(EntityLivingBase source) {
        return new EntityDamageSource("drown", (Entity)source);
    }

    public static enum DamageSourceTypes {
        PHYSICAL,
        FIRE,
        FROST,
        LIGHTNING,
        MAGIC,
        WITHER,
        THORNS,
        CACTUS,
        HOLY;

    }
}

