/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.utility.InventoryUtilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.World;

public class FlickerOperatorFishing
implements IFlickerFunctionality {
    private static final List common_items = Arrays.asList(new WeightedRandomFishable(new ItemStack((Item)Items.field_151021_T), 10).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.field_151116_aA), 10), new WeightedRandomFishable(new ItemStack(Items.field_151103_aS), 10), new WeightedRandomFishable(new ItemStack((Item)Items.field_151068_bn), 10), new WeightedRandomFishable(new ItemStack(Items.field_151007_F), 5), new WeightedRandomFishable(new ItemStack((Item)Items.field_151112_aM), 2).func_150709_a(0.9f), new WeightedRandomFishable(new ItemStack(Items.field_151054_z), 10), new WeightedRandomFishable(new ItemStack(Items.field_151055_y), 5), new WeightedRandomFishable(new ItemStack(Items.field_151100_aR, 10, 0), 1), new WeightedRandomFishable(new ItemStack((Block)Blocks.field_150479_bC), 10), new WeightedRandomFishable(new ItemStack(Items.field_151078_bh), 10));
    private static final List rare_items = Arrays.asList(new WeightedRandomFishable(new ItemStack(Blocks.field_150392_bi), 1), new WeightedRandomFishable(new ItemStack(Items.field_151057_cb), 1), new WeightedRandomFishable(new ItemStack(Items.field_151141_av), 1), new WeightedRandomFishable(new ItemStack((Item)Items.field_151031_f), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack((Item)Items.field_151112_aM), 1).func_150709_a(0.25f).func_150707_a(), new WeightedRandomFishable(new ItemStack(Items.field_151122_aG), 1).func_150707_a());
    private static final List uncommon_items = Arrays.asList(new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2), new WeightedRandomFishable(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 500;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController controller, boolean powered) {
        return this.DoOperation(worldObj, controller, powered, new Affinity[0]);
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
        TileEntity te = (TileEntity)controller;
        if (!(powered && this.checkSurroundings(worldObj, te.field_145851_c, te.field_145848_d, te.field_145849_e) && worldObj.func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e))) {
            return false;
        }
        this.transferOrEjectItem(worldObj, this.pickFishingItem(worldObj.field_73012_v), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        return true;
    }

    private boolean checkSurroundings(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j >= -2; --j) {
                for (int k = -1; k <= 1; ++k) {
                    Block block = world.func_147439_a(x + i, y + j, z + k);
                    if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private ItemStack pickFishingItem(Random rand) {
        float dropChance = rand.nextFloat();
        float minorUpgradeChance = 0.1f;
        float majorUpgradeChance = 0.05f;
        minorUpgradeChance = MathHelper.func_76131_a((float)minorUpgradeChance, (float)0.0f, (float)1.0f);
        majorUpgradeChance = MathHelper.func_76131_a((float)majorUpgradeChance, (float)0.0f, (float)1.0f);
        if (dropChance < minorUpgradeChance) {
            return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)rand, (Collection)common_items)).func_150708_a(rand);
        }
        if ((dropChance -= minorUpgradeChance) < majorUpgradeChance) {
            return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)rand, (Collection)rare_items)).func_150708_a(rand);
        }
        return ((WeightedRandomFishable)WeightedRandom.func_76271_a((Random)rand, (Collection)uncommon_items)).func_150708_a(rand);
    }

    private void transferOrEjectItem(World worldObj, ItemStack stack, int xCoord, int yCoord, int zCoord) {
        if (worldObj.field_72995_K) {
            return;
        }
        boolean eject = false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te;
                    if (i == 0 && j == 0 && k == 0 || (te = worldObj.func_147438_o(xCoord + i, yCoord + j, zCoord + k)) == null || !(te instanceof IInventory)) continue;
                    for (int side = 0; side < 6; ++side) {
                        if (!InventoryUtilities.mergeIntoInventory((IInventory)te, stack, stack.field_77994_a, side)) continue;
                        return;
                    }
                }
            }
        }
        EntityItem item = new EntityItem(worldObj);
        item.func_70107_b((double)xCoord + 0.5, (double)yCoord + 1.5, (double)zCoord + 0.5);
        item.func_92058_a(stack);
        worldObj.func_72838_d((Entity)item);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        int time = 2000;
        for (Affinity aff : flickers) {
            if (aff != Affinity.LIGHTNING) continue;
            time = (int)((double)time * 0.8);
        }
        return time;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        return new Object[]{" F ", "N W", " R ", Character.valueOf('F'), Items.field_151115_aP, Character.valueOf('W'), new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.WATER.ordinal()), Character.valueOf('N'), new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.NATURE.ordinal()), Character.valueOf('R'), Items.field_151112_aM};
    }
}

