/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.util.position;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class AABBUtil {
    public static void writeAABBListToNBT(List<AxisAlignedBB> list, NBTTagCompound nbt) {
        if (list.isEmpty()) {
            return;
        }
        NBTTagList tags = new NBTTagList();
        for (AxisAlignedBB aabb : list) {
            NBTTagCompound tag = new NBTTagCompound();
            AABBUtil.writeAABBToNBT(aabb, tag);
            tags.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("CollisionAABB", (NBTBase)tags);
    }

    public static void writeAABBToNBT(AxisAlignedBB aabb, NBTTagCompound nbt) {
        nbt.func_74780_a("minX", aabb.field_72340_a);
        nbt.func_74780_a("maxX", aabb.field_72336_d);
        nbt.func_74780_a("minY", aabb.field_72338_b);
        nbt.func_74780_a("maxY", aabb.field_72337_e);
        nbt.func_74780_a("minZ", aabb.field_72339_c);
        nbt.func_74780_a("maxZ", aabb.field_72334_f);
    }

    public static AxisAlignedBB readAABBFromNBT(NBTTagCompound tag) {
        double minX = tag.func_74769_h("minX");
        double maxX = tag.func_74769_h("maxX");
        double minY = tag.func_74769_h("minY");
        double maxY = tag.func_74769_h("maxY");
        double minZ = tag.func_74769_h("minZ");
        double maxZ = tag.func_74769_h("maxZ");
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static void writeCollisionBoundingBoxesToNBT(World world, int x, int y, int z, NBTTagCompound nbt) {
        Block block = world.func_147439_a(x, y, z);
        try {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            block.func_149743_a(world, x, y, z, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)), list, null);
            if (!list.isEmpty()) {
                for (AxisAlignedBB aabb : list) {
                    aabb.func_72317_d((double)(-x), (double)(-y), (double)(-z));
                }
                AABBUtil.writeAABBListToNBT(list, nbt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ArrayList<AxisAlignedBB> readAABBsFromNBT(NBTTagCompound nbt) {
        NBTTagList tags;
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        if (nbt.func_74764_b("CollisionAABB") && (tags = nbt.func_150295_c("CollisionAABB", 10)).func_74745_c() > 0) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound tag = tags.func_150305_b(i);
                AxisAlignedBB aabb = AABBUtil.readAABBFromNBT(tag);
                list.add(aabb);
            }
        }
        return list;
    }
}

